/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSocket;
import org.limewire.rudp.UDPSocketChannel;

class UDPConnection
extends AbstractNBSocket
implements RUDPSocket {
    private final UDPSocketChannel channel;
    private int soTimeout = 60000;
    private final RUDPContext context;

    UDPConnection(RUDPContext context, UDPSocketChannel channel) {
        this.context = context;
        this.channel = channel;
        this.setInitialReader();
        this.setInitialWriter();
    }

    protected InterestReadableByteChannel getBaseReadChannel() {
        return this.channel;
    }

    protected InterestWritableByteChannel getBaseWriteChannel() {
        return this.channel;
    }

    protected void shutdownImpl() {
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public InetAddress getLocalAddress() {
        return this.context.getUDPService().getStableListeningAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.channel.getRemoteSocketAddress();
    }

    public InetAddress getInetAddress() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getAddress();
    }

    public int getPort() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getPort();
    }

    public int getLocalPort() {
        return this.context.getUDPService().getStableListeningPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "UDPConnection:" + this.channel;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.channel.isOpen();
    }

    public boolean isOutputShutdown() {
        return !this.channel.isOpen();
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new IOException("not implemented");
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new IOException("not implemented");
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getOOBInline() throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return 10240;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return 81920;
    }

    public void setKeepAlive(boolean on) throws SocketException {
    }

    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    public void setTrafficClass(int tc) throws SocketException {
        throw new SocketException("not implemented");
    }

    public int getTrafficClass() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void setReuseAddress(boolean on) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getReuseAddress() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void shutdownInput() throws IOException {
        throw new SocketException("not implemented");
    }

    public void shutdownOutput() throws IOException {
        throw new IOException("not implemented");
    }
}

