/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages;

import java.io.IOException;
import java.io.OutputStream;
import org.limewire.rudp.messages.MessageFormatException;

public interface RUDPMessage {
    public static final byte F_RUDP_MESSAGE = 65;
    public static final short PROTOCOL_VERSION_NUMBER = 0;

    public OpCode getOpCode();

    public void write(OutputStream var1) throws IOException;

    public byte getConnectionID();

    public long getSequenceNumber();

    public void extendSequenceNumber(long var1);

    public int getDataLength();

    public int getLength();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpCode {
        OP_SYN(0),
        OP_ACK(1),
        OP_KEEPALIVE(2),
        OP_DATA(3),
        OP_FIN(4);

        private int opcode;
        private static OpCode[] OPCODES;

        private OpCode(int opcode) {
            this.opcode = opcode;
        }

        public int toByte() {
            return this.opcode;
        }

        public String toString() {
            return this.name() + " (" + this.toByte() + ")";
        }

        public static OpCode valueOf(int opcode) throws MessageFormatException {
            OpCode o = OPCODES[opcode % OPCODES.length];
            if (o != null && o.opcode == opcode) {
                return o;
            }
            throw new MessageFormatException("Unknown opcode: " + opcode);
        }

        static {
            OpCode[] values = OpCode.values();
            OPCODES = new OpCode[values.length];
            for (OpCode o : values) {
                int index = o.opcode % OPCODES.length;
                if (OPCODES[index] != null) {
                    throw new IllegalStateException("OpCode collision: index=" + index + ", OPCODES=" + (Object)((Object)OPCODES[index]) + ", o=" + (Object)((Object)o));
                }
                OpCode.OPCODES[index] = o;
            }
        }
    }
}

