/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

class DataMessageImpl
extends RUDPMessageImpl
implements DataMessage {
    private final ByteBuffer chunk;

    DataMessageImpl(byte connectionID, long sequenceNumber, ByteBuffer chunk) {
        super(connectionID, RUDPMessage.OpCode.OP_DATA, sequenceNumber, chunk.array(), chunk.remaining());
        this.chunk = chunk;
    }

    DataMessageImpl(byte connectionID, long sequenceNumber, byte[] data, int len) {
        super(connectionID, RUDPMessage.OpCode.OP_DATA, sequenceNumber, data, len);
        this.chunk = null;
    }

    public ByteBuffer getChunk() {
        return this.chunk;
    }

    DataMessageImpl(byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_DATA, connectionId, sequenceNumber, data1, data2);
        this.chunk = null;
    }

    public ByteBuffer getData1Chunk() {
        return this._data1;
    }

    public ByteBuffer getData2Chunk() {
        return this._data2;
    }

    public byte getDataAt(int i) {
        if (i < 12) {
            return this._data1.get(i + this._data1.position());
        }
        return this._data2.get(i - 12 + this._data2.position());
    }

    public String toString() {
        return "DataMessage DestID:" + this.getConnectionID() + " len:" + this.getDataLength() + " seq:" + this.getSequenceNumber();
    }

    protected int getData1Length() {
        return this._data1.limit();
    }
}

