/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.io.ByteBufferInputStream;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.rudp.messages.impl.AckMessageImpl;
import org.limewire.rudp.messages.impl.DataMessageImpl;
import org.limewire.rudp.messages.impl.FinMessageImpl;
import org.limewire.rudp.messages.impl.KeepAliveMessageImpl;
import org.limewire.rudp.messages.impl.SynMessageImpl;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

@Singleton
public class DefaultMessageFactory
implements RUDPMessageFactory {
    private static final MessageFormatException NO_MATCH = new MessageFormatException("No matching RUDPMessage");

    public RUDPMessage createMessage(ByteBuffer ... data) throws MessageFormatException {
        ByteBufferInputStream in = new ByteBufferInputStream(data);
        if (in.available() < 23) {
            throw new MessageFormatException("not enough data for header!");
        }
        byte connectionID = (byte)in.read();
        byte b = (byte)in.read();
        RUDPMessage.OpCode opcode = RUDPMessage.OpCode.valueOf((b & 0xF0) >> 4);
        long sequenceNumber = ((long)in.read() & 0xFFL) << 8 | (long)in.read() & 0xFFL;
        int data1Length = b & 0xF;
        if (data1Length > 12) {
            throw new MessageFormatException("data1Length too big: " + data1Length);
        }
        ByteBuffer data1 = ByteBuffer.allocate(12);
        in.read(data1);
        data1.flip();
        if (opcode == RUDPMessage.OpCode.OP_DATA) {
            data1.limit(data1Length);
        }
        in.skip(3L);
        int remaining = -1;
        try {
            remaining = ByteUtils.leb2int(in);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        if (remaining != in.available()) {
            throw new MessageFormatException("inconsistent message size.  expected: " + remaining + ", was: " + in.available());
        }
        ByteBuffer data2 = in.bufferFor(remaining);
        assert (in.available() == 0);
        switch (opcode) {
            case OP_SYN: {
                return new SynMessageImpl(connectionID, sequenceNumber, data1, data2);
            }
            case OP_ACK: {
                return new AckMessageImpl(connectionID, sequenceNumber, data1, data2);
            }
            case OP_KEEPALIVE: {
                return new KeepAliveMessageImpl(connectionID, sequenceNumber, data1, data2);
            }
            case OP_DATA: {
                return new DataMessageImpl(connectionID, sequenceNumber, data1, data2);
            }
            case OP_FIN: {
                return new FinMessageImpl(connectionID, sequenceNumber, data1, data2);
            }
        }
        throw NO_MATCH;
    }

    public DataMessage createDataMessage(byte connectionID, long sequenceNumber, ByteBuffer chunk) {
        return new DataMessageImpl(connectionID, sequenceNumber, chunk);
    }

    public AckMessage createAckMessage(byte connectionID, long sequenceNumber, long windowStart, int windowSpace) {
        return new AckMessageImpl(connectionID, sequenceNumber, windowStart, windowSpace);
    }

    public FinMessage createFinMessage(byte connectionID, long sequenceNumber, byte reasonCode) {
        return new FinMessageImpl(connectionID, sequenceNumber, reasonCode);
    }

    public KeepAliveMessage createKeepAliveMessage(byte connectionID, long windowStart, int windowSpace) {
        return new KeepAliveMessageImpl(connectionID, windowStart, windowSpace);
    }

    public SynMessage createSynMessage(byte connectionID) {
        return new SynMessageImpl(connectionID);
    }

    public SynMessage createSynMessage(byte connectionID, byte theirConnectionID) {
        return new SynMessageImpl(connectionID, theirConnectionID);
    }
}

