/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

class KeepAliveMessageImpl
extends RUDPMessageImpl
implements KeepAliveMessage {
    private long _windowStart;
    private int _windowSpace;

    KeepAliveMessageImpl(byte connectionID, long windowStart, int windowSpace) {
        super(connectionID, RUDPMessage.OpCode.OP_KEEPALIVE, 0L, (short)(windowStart & 0xFFFFL), (short)(windowSpace < 0 ? 0 : windowSpace & 0xFFFF));
        this._windowStart = windowStart;
        this._windowSpace = windowSpace;
    }

    KeepAliveMessageImpl(byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_KEEPALIVE, connectionId, sequenceNumber, data1, data2);
        if (data1.remaining() < 4) {
            throw new MessageFormatException("Message not long enough, message length " + data1.remaining() + " < 4");
        }
        data1.order(ByteOrder.BIG_ENDIAN);
        this._windowStart = data1.getShort();
        this._windowSpace = data1.getShort();
        data1.rewind();
    }

    public long getWindowStart() {
        return this._windowStart;
    }

    public void extendWindowStart(long wStart) {
        this._windowStart = wStart;
    }

    public int getWindowSpace() {
        return this._windowSpace;
    }

    public String toString() {
        return "KeepAliveMessage DestID:" + this.getConnectionID() + " start:" + this._windowStart + " space:" + this._windowSpace;
    }
}

