/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

public class SynMessageImpl
extends RUDPMessageImpl
implements SynMessage {
    private final byte _senderConnectionID;
    private final short _protocolVersionNumber;

    SynMessageImpl(byte connectionID) {
        super((byte)0, RUDPMessage.OpCode.OP_SYN, 0L, connectionID, (short)0);
        this._senderConnectionID = connectionID;
        this._protocolVersionNumber = 0;
    }

    SynMessageImpl(byte connectionID, byte theirConnectionID) {
        super(theirConnectionID, RUDPMessage.OpCode.OP_SYN, 0L, connectionID, (short)0);
        this._senderConnectionID = connectionID;
        this._protocolVersionNumber = 0;
    }

    SynMessageImpl(byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_SYN, connectionId, sequenceNumber, data1, data2);
        if (data1.remaining() < 3) {
            throw new MessageFormatException("Message not long enough, message length " + data1.remaining() + " < 3");
        }
        this._senderConnectionID = data1.get();
        data1.order(ByteOrder.BIG_ENDIAN);
        this._protocolVersionNumber = data1.getShort();
        data1.rewind();
    }

    public byte getSenderConnectionID() {
        return this._senderConnectionID;
    }

    public int getProtocolVersionNumber() {
        return this._protocolVersionNumber;
    }

    public String toString() {
        return "SynMessage DestID:" + this.getConnectionID() + " SrcID:" + this._senderConnectionID + " vNo:" + this._protocolVersionNumber;
    }
}

