/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.security.certificate.RootCAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CertificateVerifierImpl
implements CertificateVerifier {
    private static final Log LOG = LogFactory.getLog(CertificateVerifierImpl.class);
    private KeyStoreProvider keyStoreProvider;
    private RootCAProvider rootCAProvider;

    @Inject
    public CertificateVerifierImpl(KeyStoreProvider keyStoreProvider, RootCAProvider rootCAProvider) {
        this.keyStoreProvider = keyStoreProvider;
        this.rootCAProvider = rootCAProvider;
    }

    @Override
    public boolean isValid(Certificate certificate) {
        KeyStore ks;
        try {
            ks = this.keyStoreProvider.getKeyStore();
        }
        catch (IOException ex) {
            LOG.error("IOException getting keyStore", ex);
            return false;
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            ArrayList<Certificate> certList = new ArrayList<Certificate>();
            certList.add(certificate);
            this.populateCertList(ks, certificate, certList);
            CertPath certPath = certFactory.generateCertPath(certList);
            TrustAnchor anchor = new TrustAnchor(this.rootCAProvider.getCertificate(), null);
            PKIXParameters params = new PKIXParameters(Collections.singleton(anchor));
            params.setRevocationEnabled(false);
            try {
                certPathValidator.validate(certPath, params);
            }
            catch (CertPathValidatorException ex) {
                LOG.error("Validation failure, cert[" + ex.getIndex() + "] :", ex);
                return false;
            }
        }
        catch (GeneralSecurityException ex) {
            LOG.error("CertificateException caught.", ex);
            return false;
        }
        return true;
    }

    private void populateCertList(KeyStore keyStore, Certificate certificate, List<Certificate> certs) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)certificate;
            String dn = x509.getIssuerDN().getName();
            String cn = "";
            for (String token : dn.split(",")) {
                if (!token.trim().startsWith("CN=")) continue;
                cn = token.trim().substring(3);
                break;
            }
            if (x509.getIssuerDN().getName().equals(x509.getSubjectDN().getName())) {
                return;
            }
            try {
                Certificate issuerCert = keyStore.getCertificate(cn);
                if (issuerCert == null) {
                    LOG.error("Could not find certificate alias '" + cn + "'");
                    return;
                }
                certs.add(issuerCert);
                this.populateCertList(keyStore, issuerCert, certs);
            }
            catch (KeyStoreException ex) {
                LOG.error("KeyStoreException caught while walking chain.", ex);
                return;
            }
        }
    }
}

