/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public interface CipherProvider {
    public byte[] encrypt(byte[] var1, Key var2, CipherType var3) throws IOException;

    public byte[] decrypt(byte[] var1, Key var2, CipherType var3) throws IOException;

    public byte[] sign(byte[] var1, PrivateKey var2, SignatureType var3) throws IOException;

    public boolean verify(byte[] var1, byte[] var2, PublicKey var3, SignatureType var4) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureType {
        SHA1_WITH_RSA("SHA1withRSA");

        private String description;

        public String getDescription() {
            return this.description;
        }

        private SignatureType(String description) {
            this.description = description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CipherType {
        RSA("RSA/ECB/PKCS1Padding"),
        AES("AES");

        private String description;

        public String getDescription() {
            return this.description;
        }

        private CipherType(String description) {
            this.description = description;
        }
    }
}

