/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.HashCalculator;

public class HashCalculatorSHA1Impl
implements HashCalculator {
    public byte[] calculate(byte[] in) {
        try {
            return this.calculate(new ByteArrayInputStream(in));
        }
        catch (IOException ex) {
            throw new RuntimeException("Impossible IOException caught: ", ex);
        }
    }

    public byte[] calculate(InputStream in) throws IOException {
        try {
            int bytesRead;
            MessageDigest outputSHA1 = MessageDigest.getInstance("SHA-1");
            byte[] data = new byte[65536];
            while ((bytesRead = in.read(data)) >= 0) {
                outputSHA1.update(data, 0, bytesRead);
            }
            return outputSHA1.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw IOUtils.getIOException("NoSuchAlgorithmException during computation: ", ex);
        }
    }
}

