/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Singleton;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.certificate.HashLookupProvider;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;

@Singleton
public class HashLookupProviderDNSTXTImpl
implements HashLookupProvider {
    private static final Log LOG = LogFactory.getLog(HashLookupProviderDNSTXTImpl.class);

    public String lookup(String key) {
        try {
            Lookup lookup = new Lookup(key, 16);
            lookup.run();
            int result = lookup.getResult();
            if (result != 0) {
                throw new IOException("Error during lookup: " + lookup.getErrorString());
            }
            Record[] answers = lookup.getAnswers();
            if (answers == null || answers.length != 1) {
                throw new IOException("Incorrect number of answers, expected 1.");
            }
            return this.stripLeadingTrailingQuotes(answers[0].rdataToString());
        }
        catch (IOException ex) {
            LOG.error("Failed lookup for key '" + key + "'", ex);
            return null;
        }
    }

    String stripLeadingTrailingQuotes(String incoming) {
        if (incoming == null || incoming.length() == 0) {
            return incoming;
        }
        boolean start = incoming.charAt(0) == '\"';
        boolean end = incoming.charAt(incoming.length() - 1) == '\"';
        return incoming.substring(start ? 1 : 0, incoming.length() - (end ? 1 : 0));
    }
}

