/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.CertificateTools;
import org.limewire.security.certificate.KeyStoreProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class KeyStoreProviderImpl
implements KeyStoreProvider {
    private volatile KeyStore keyStore = null;
    private final Provider<LimeHttpClient> httpClient;
    private volatile File keyStoreLocation;
    private volatile char[] keyStorePassword;
    private final Log LOG = LogFactory.getLog(KeyStoreProviderImpl.class);

    @Inject
    KeyStoreProviderImpl(Provider<LimeHttpClient> httpClient) {
        this.httpClient = httpClient;
        this.keyStoreLocation = CertificateTools.getKeyStoreLocation();
        this.keyStorePassword = CertificateTools.getKeyStorePassword();
    }

    void setKeyStoreLocation(File location) {
        this.keyStoreLocation = location;
    }

    void setKeyStorePassword(char[] password) {
        this.keyStorePassword = password;
    }

    @Override
    public KeyStore getKeyStore() throws IOException {
        if (this.isValid(this.keyStore)) {
            return this.keyStore;
        }
        try {
            this.keyStore = this.getKeyStoreFromDisk();
            return this.keyStore;
        }
        catch (IOException ex) {
            this.LOG.debug("IOException trying to load keystore from disk.", ex);
            OutputStream out = null;
            try {
                this.keyStore = this.getKeyStoreFromNetwork();
                this.keyStoreLocation.getParentFile().mkdirs();
                out = new FileOutputStream(this.keyStoreLocation);
                this.keyStore.store(out, this.keyStorePassword);
                KeyStore keyStore = this.keyStore;
                return keyStore;
            }
            catch (KeyStoreException ex2) {
                throw IOUtils.getIOException("KeyStoreException while saving keystore: ", ex2);
            }
            catch (NoSuchAlgorithmException ex3) {
                throw IOUtils.getIOException("NoSuchAlgorithmException while saving keystore: ", ex3);
            }
            catch (CertificateException ex4) {
                throw IOUtils.getIOException("CertificateException while saving keystore: ", ex4);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    KeyStore getKeyStoreFromNetwork() throws IOException {
        KeyStore newKeyStore;
        LimeHttpClient client = this.httpClient.get();
        HttpGet get = new HttpGet(CertificateTools.getKeyStoreURI());
        try {
            newKeyStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException ex) {
            throw new IOException("KeyStoreException instantiating keystore: " + ex.getMessage());
        }
        HttpResponse response = null;
        try {
            try {
                response = client.execute(get);
            }
            catch (HttpException httpX) {
                throw (IOException)new IOException().initCause(httpX);
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                try {
                    newKeyStore.load(response.getEntity().getContent(), this.keyStorePassword);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", ex);
                }
                catch (CertificateException ex) {
                    throw IOUtils.getIOException("CertificateException while parsing keystore: ", ex);
                }
                KeyStore keyStore = newKeyStore;
                return keyStore;
            }
            throw new IOException("Failed to download new keystore (" + CertificateTools.getKeyStoreURI().toString() + "): " + response.getStatusLine());
        }
        finally {
            client.releaseConnection(response);
        }
    }

    KeyStore getKeyStoreFromDisk() throws IOException {
        InputStream in = null;
        try {
            KeyStore newKeyStore = KeyStore.getInstance("jks");
            in = new BufferedInputStream(new FileInputStream(this.keyStoreLocation));
            newKeyStore.load(in, this.keyStorePassword);
            KeyStore keyStore = newKeyStore;
            return keyStore;
        }
        catch (KeyStoreException ex) {
            throw IOUtils.getIOException("KeyStoreException while creating keystore in memory: ", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", ex);
        }
        catch (CertificateException ex) {
            throw IOUtils.getIOException("CertificateException while parsing keystore: ", ex);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void invalidateKeyStore() {
        this.keyStore = null;
        this.keyStoreLocation.delete();
    }

    private boolean isValid(KeyStore ks) {
        if (ks == null) {
            return false;
        }
        try {
            if (ks.size() > 0) {
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isCached() {
        if (this.isValid(this.keyStore)) {
            return true;
        }
        if (this.keyStoreLocation.exists()) {
            try {
                if (this.isValid(this.getKeyStoreFromDisk())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

