/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.limewire.security.certificate.CertificateProps;
import org.limewire.security.certificate.CertificateTools;
import org.limewire.security.certificate.HashCalculator;
import org.limewire.security.certificate.HashLookupProvider;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.security.certificate.RootCAProvider;

@Singleton
public class RootCAProviderImpl
implements RootCAProvider {
    KeyStoreProvider keyStoreProvider;
    HashCalculator hashCalculator;
    HashLookupProvider hashLookupProvider;

    @Inject
    public RootCAProviderImpl(KeyStoreProvider keyStoreProvider, HashCalculator hashCalculator, HashLookupProvider hashLookupProvider) {
        this.keyStoreProvider = keyStoreProvider;
        this.hashCalculator = hashCalculator;
        this.hashLookupProvider = hashLookupProvider;
    }

    public X509Certificate getCertificate() throws CertificateException {
        try {
            return this.getCertificateNoRetry();
        }
        catch (CertificateException ex) {
            this.keyStoreProvider.invalidateKeyStore();
            return this.getCertificateNoRetry();
        }
    }

    private X509Certificate getCertificateNoRetry() throws CertificateException {
        String CA_ALIAS = CertificateProps.getCACertAlias();
        try {
            String actualHash;
            KeyStore ks = this.keyStoreProvider.getKeyStore();
            X509Certificate certificate = (X509Certificate)ks.getCertificate(CA_ALIAS);
            String expectedHash = this.hashLookupProvider.lookup(CertificateProps.getCAHashLookupKey());
            if (expectedHash != null && !expectedHash.equalsIgnoreCase(actualHash = CertificateTools.getCertificateHash(certificate, this.hashCalculator))) {
                throw new CertificateException("CA-hash does not match expected. actual->'" + actualHash + "'!='" + expectedHash + "'");
            }
            return certificate;
        }
        catch (IOException ex) {
            throw new CertificateException("IOException getting certificate", ex);
        }
        catch (KeyStoreException ex) {
            throw new CertificateException("KeyStoreException getting certificate", ex);
        }
    }
}

