/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public class FileSetting
extends AbstractSetting {
    private File value;
    private String absolutePath;

    FileSetting(Properties defaultProps, Properties props, String key, File defaultFile) {
        super(defaultProps, props, key, defaultFile.getAbsolutePath());
        this.setPrivate(true);
    }

    public File getValue() {
        return new File(this.absolutePath);
    }

    public void setValue(File value) {
        this.setValueInternal(value.getAbsolutePath());
    }

    protected void loadValue(String sValue) {
        this.value = new File(sValue);
        this.absolutePath = this.value.getAbsolutePath();
    }

    public FileSetting setAlwaysSave(boolean on) {
        super.setAlwaysSave(on);
        return this;
    }

    public FileSetting createParentDirs() {
        File parent;
        String parentString;
        File value = this.getValue();
        if (value != null && (parentString = value.getParent()) != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        return this;
    }
}

