/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractNumberSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatSetting
extends AbstractNumberSetting<Float> {
    private float value;

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), false, null, null);
    }

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat, float min, float max) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), true, new Float(min), new Float(max));
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.setValueInternal(String.valueOf(value));
    }

    @Override
    protected void loadValue(String sValue) {
        try {
            this.value = Float.valueOf(sValue.trim()).floatValue();
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    @Override
    protected Comparable<Float> convertToComparable(String value) {
        return new Float(value);
    }
}

