/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.BitSet;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.StringUtils;

public class PBooleanArraySetting
extends AbstractSetting {
    private volatile BitSet values = new BitSet();
    private volatile int size;

    public PBooleanArraySetting(Properties defaultProps, Properties props, String key, String[] defaultValue) {
        super(defaultProps, props, key, PBooleanArraySetting.decode(defaultValue));
    }

    protected void loadValue(String sValue) {
        String[] values = PBooleanArraySetting.encode(sValue);
        float[] fvalues = new float[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                fvalues[i] = Float.parseFloat(values[i]);
            }
        }
        catch (NumberFormatException bad) {
            return;
        }
        BitSet newValues = new BitSet(values.length);
        for (int i = 0; i < fvalues.length; ++i) {
            if (!(Math.random() <= (double)fvalues[i])) continue;
            newValues.set(i);
        }
        this.size = fvalues.length;
        this.values = newValues;
    }

    public void setValue(String ... value) {
        this.setValueInternal(PBooleanArraySetting.decode(value));
    }

    public int length() {
        return this.size;
    }

    public boolean get(int index) {
        return this.values.get(index);
    }

    private static final String[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new String[0];
        }
        return StringUtils.split(src, ";");
    }

    private static final String decode(String[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String str : src) {
            buffer.append(str).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

