/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.limewire.service.ErrorService;
import org.limewire.setting.AbstractSetting;

public final class PasswordSetting
extends AbstractSetting {
    public static final String MD5 = "MD5";
    private static final String[] ALGORITHMS = new String[]{"MD5"};
    private static final String SEPERATOR = "/";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String algorithm;
    private String value;

    PasswordSetting(Properties defaultProps, Properties props, String algorithm, String key, String defaultStr) {
        super(defaultProps, props, key, PasswordSetting.isEncrypted(defaultStr) ? defaultStr : PasswordSetting.encrypt(algorithm, defaultStr));
        this.postInitWithAlgorithm(algorithm);
        this.setPrivate(true);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(String password) {
        if (password == null) {
            return false;
        }
        if (!PasswordSetting.isEncrypted(password)) {
            password = PasswordSetting.encrypt(this.algorithm, password);
        }
        if (!password.startsWith(this.algorithm + SEPERATOR)) {
            throw new IllegalArgumentException("Algorithm mismatch");
        }
        return this.value.equalsIgnoreCase(password);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String str) {
        this.setValueInternal(str);
    }

    protected void loadValue(String sValue) {
        if (this.algorithm != null && !PasswordSetting.isEncrypted(sValue)) {
            this.setValue(PasswordSetting.encrypt(this.algorithm, sValue));
            return;
        }
        this.value = sValue;
    }

    private void postInitWithAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if (algorithm != null && !PasswordSetting.isEncrypted(this.value)) {
            this.setValue(PasswordSetting.encrypt(algorithm, this.value));
        }
    }

    private static boolean isEncrypted(String password) {
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            if (!password.startsWith(ALGORITHMS[i] + SEPERATOR)) continue;
            return true;
        }
        return false;
    }

    private static String encrypt(String algorithm, String password) {
        return PasswordSetting.encrypt(algorithm, "UTF-8", password);
    }

    private static String encrypt(String algorithm, String encoding, String password) {
        if (password == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(password.getBytes(encoding));
            return algorithm + SEPERATOR + PasswordSetting.toHexString(digest);
        }
        catch (UnsupportedEncodingException err) {
            ErrorService.error(err);
            return null;
        }
        catch (NoSuchAlgorithmException err) {
            ErrorService.error(err);
            return null;
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder buffer = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            buffer.append(HEX[b[i] >> 4 & 0xF]).append(HEX[b[i] & 0xF]);
        }
        return buffer.toString();
    }

    public static String toEncrypted(String algorithm, String value) {
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            if (!ALGORITHMS[i].equals(algorithm)) continue;
            return algorithm + SEPERATOR + value;
        }
        throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
    }
}

