/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.BooleanSettingImpl;
import org.limewire.setting.ByteSetting;
import org.limewire.setting.CharArraySetting;
import org.limewire.setting.ColorSetting;
import org.limewire.setting.FileArraySetting;
import org.limewire.setting.FileSetSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.FontNameSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.NullRemoteManager;
import org.limewire.setting.PBooleanArraySetting;
import org.limewire.setting.PasswordSetting;
import org.limewire.setting.PowerOfTwoSetting;
import org.limewire.setting.ProbabilisticBooleanSetting;
import org.limewire.setting.PropertiesSetting;
import org.limewire.setting.ProxyFileSetting;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetSetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsFactory
implements Iterable<AbstractSetting>,
RemoteSettingController {
    private static boolean loadSaveFailureEncountered = false;
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private LongSetting LAST_EXPIRE_TIME = null;
    private BooleanSetting REVERT_UNLISTED_REMOTE = null;
    private File SETTINGS_FILE;
    private final String HEADING;
    protected final Properties DEFAULT_PROPS = new Properties();
    protected final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private ArrayList<AbstractSetting> settings = new ArrayList(10);
    private Map<String, AbstractSetting> remoteKeyToSetting = new HashMap<String, AbstractSetting>();
    private RemoteSettingManager remoteManager = new NullRemoteManager();
    private boolean expired = false;

    public SettingsFactory(File settingsFile) {
        this(settingsFile, "");
    }

    public SettingsFactory(File settingsFile, String heading) {
        this.SETTINGS_FILE = settingsFile;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = heading;
        this.reload();
    }

    public static boolean hasLoadSaveFailure() {
        return loadSaveFailureEncountered;
    }

    private static void markFailure() {
        loadSaveFailureEncountered = true;
    }

    public static void resetLoadSaveFailure() {
        loadSaveFailureEncountered = false;
    }

    @Override
    public synchronized Iterator<AbstractSetting> iterator() {
        return this.settings.iterator();
    }

    public BooleanSetting getRevertSetting() {
        return this.REVERT_UNLISTED_REMOTE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() {
        if (this.REVERT_UNLISTED_REMOTE == null) {
            this.REVERT_UNLISTED_REMOTE = this.createBooleanSetting("REVERT_UNLISTED_REMOTE", true);
        }
        if (!this.SETTINGS_FILE.isFile()) {
            this.setExpireValue();
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.SETTINGS_FILE);
            try {
                this.PROPS.load(fis);
            }
            catch (IllegalArgumentException e) {
            }
            catch (StringIndexOutOfBoundsException e) {
            }
            catch (IOException e) {
                SettingsFactory.markFailure();
            }
        }
        catch (FileNotFoundException e) {
            block11: {
                try {
                    if (!this.SETTINGS_FILE.exists()) break block11;
                    SettingsFactory.markFailure();
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    throw throwable;
                }
            }
            FileUtils.close(fis);
        }
        FileUtils.close(fis);
        for (AbstractSetting set : this.settings) {
            set.reload();
        }
        this.setExpireValue();
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized void changeFile(File toUse) {
        this.SETTINGS_FILE = toUse;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.revertToDefault();
        this.reload();
    }

    public synchronized boolean revertToDefault() {
        boolean any = false;
        for (AbstractSetting setting : this.settings) {
            any |= setting.revertToDefault();
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        Properties toSave = (Properties)this.PROPS.clone();
        for (AbstractSetting set : this.settings) {
            if (set.shouldAlwaysSave() || !set.isDefault()) continue;
            toSave.remove(set.getKey());
        }
        BufferedOutputStream out = null;
        try {
            block13: {
                File parent;
                if (this.SETTINGS_FILE.isDirectory()) {
                    this.SETTINGS_FILE.delete();
                }
                if ((parent = this.SETTINGS_FILE.getParentFile()) != null) {
                    parent.mkdirs();
                }
                FileUtils.setWriteable(this.SETTINGS_FILE);
                if (this.SETTINGS_FILE.exists() && !this.SETTINGS_FILE.canRead()) {
                    this.SETTINGS_FILE.delete();
                }
                try {
                    out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
                catch (IOException ioe) {
                    if (!this.SETTINGS_FILE.exists()) break block13;
                    this.SETTINGS_FILE.delete();
                    out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
            }
            if (out != null) {
                toSave.store(out, this.HEADING);
            } else {
                SettingsFactory.markFailure();
            }
            FileUtils.close(out);
        }
        catch (IOException e) {
            SettingsFactory.markFailure();
        }
        finally {
            FileUtils.close(out);
        }
    }

    public String toString() {
        return this.PROPS.toString();
    }

    Properties getProperties() {
        return this.PROPS;
    }

    public synchronized void setRemoteSettingManager(RemoteSettingManager manager) {
        this.remoteManager = manager;
        manager.setRemoteSettingController(this);
    }

    @Override
    public synchronized boolean updateSetting(String remoteKey, String value) {
        AbstractSetting setting = this.remoteKeyToSetting.get(remoteKey);
        if (setting != null) {
            setting.setValueInternal(value);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void revertRemoteSettingsUnlessIn(Set<String> keySet) {
        if (this.REVERT_UNLISTED_REMOTE.getValue()) {
            for (Map.Entry<String, AbstractSetting> entry : this.remoteKeyToSetting.entrySet()) {
                if (keySet.contains(entry.getKey())) continue;
                entry.getValue().revertToDefault();
            }
        }
    }

    public synchronized StringSetting createStringSetting(String key, String defaultValue) {
        StringSetting result = new StringSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized StringSetting createRemoteStringSetting(String key, String defaultValue, String remoteKey) {
        StringSetting result = new StringSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized BooleanSetting createBooleanSetting(String key, boolean defaultValue) {
        BooleanSettingImpl result = new BooleanSettingImpl(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized BooleanSetting createRemoteBooleanSetting(String key, boolean defaultValue, String remoteKey) {
        BooleanSettingImpl result = new BooleanSettingImpl(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized IntSetting createIntSetting(String key, int defaultValue) {
        IntSetting result = new IntSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized IntSetting createRemoteIntSetting(String key, int defaultValue, String remoteKey, int min, int max) {
        IntSetting result = new IntSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized ByteSetting createByteSetting(String key, byte defaultValue) {
        ByteSetting result = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ByteSetting createRemoteByteSetting(String key, byte defaultValue, String remoteKey, byte min, byte max) {
        ByteSetting result = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized LongSetting createLongSetting(String key, long defaultValue) {
        LongSetting result = new LongSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized LongSetting createRemoteLongSetting(String key, long defaultValue, String remoteKey, long min, long max) {
        LongSetting result = new LongSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized PowerOfTwoSetting createPowerOfTwoSetting(String key, long defaultValue) {
        PowerOfTwoSetting result = new PowerOfTwoSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized PowerOfTwoSetting createRemotePowerOfTwoSetting(String key, long defaultValue, String remoteKey, long min, long max) {
        PowerOfTwoSetting result = new PowerOfTwoSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized FileSetting createFileSetting(String key, File defaultValue) {
        FileSetting result = new FileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileSetting createRemoteFileSetting(String key, File defaultValue, String remoteKey) {
        File parent;
        String parentString = defaultValue.getParent();
        if (parentString != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        FileSetting result = new FileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized ProxyFileSetting createProxyFileSetting(String key, FileSetting defaultSetting) {
        ProxyFileSetting result = new ProxyFileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultSetting);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ColorSetting createColorSetting(String key, Color defaultValue) {
        ColorSetting result = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ColorSetting createRemoteColorSetting(String key, Color defaultValue, String remoteKey) {
        ColorSetting result = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized CharArraySetting createCharArraySetting(String key, char[] defaultValue) {
        CharArraySetting result = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized CharArraySetting createRemoteCharArraySetting(String key, char[] defaultValue, String remoteKey) {
        CharArraySetting result = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized FloatSetting createFloatSetting(String key, float defaultValue) {
        FloatSetting result = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FloatSetting createRemoteFloatSetting(String key, float defaultValue, String remoteKey, float min, float max) {
        FloatSetting result = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized StringArraySetting createStringArraySetting(String key, String[] defaultValue) {
        StringArraySetting result = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized PropertiesSetting createPropertiesSetting(String key, Properties defaultValue) {
        PropertiesSetting result = new PropertiesSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized StringArraySetting createRemoteStringArraySetting(String key, String[] defaultValue, String remoteKey) {
        StringArraySetting result = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized StringSetSetting createStringSetSetting(String key, String defaultValue) {
        StringSetSetting result = new StringSetSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileArraySetting createFileArraySetting(String key, File[] defaultValue) {
        FileArraySetting result = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileArraySetting createRemoteFileArraySetting(String key, File[] defaultValue, String remoteKey) {
        FileArraySetting result = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized FileSetSetting createFileSetSetting(String key, File[] defaultValue) {
        FileSetSetting result = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileSetSetting createRemoteFileSetSetting(String key, File[] defaultValue, String remoteKey) {
        FileSetSetting result = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized BooleanSetting createExpirableBooleanSetting(String key, boolean defaultValue) {
        BooleanSetting result = this.createBooleanSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    public synchronized IntSetting createExpirableIntSetting(String key, int defaultValue) {
        IntSetting result = this.createIntSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    public synchronized LongSetting createExpirableLongSetting(String key, long defaultValue) {
        LongSetting result = this.createLongSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    public synchronized FontNameSetting createFontNameSetting(String key, String defaultValue) {
        FontNameSetting result = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FontNameSetting createRemoteFontNameSetting(String key, String defaultValue, String remoteKey) {
        FontNameSetting result = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized ProbabilisticBooleanSetting createProbabilisticBooleanSetting(String key, float defaultValue) {
        ProbabilisticBooleanSetting result = new ProbabilisticBooleanSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ProbabilisticBooleanSetting createRemoteProbabilisticBooleanSetting(String key, float defaultValue, String remoteKey, float min, float max) {
        ProbabilisticBooleanSetting result = new ProbabilisticBooleanSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, min, max);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized PBooleanArraySetting createPBooleanArraySetting(String key, String[] defaultValue) {
        PBooleanArraySetting result = new PBooleanArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized PBooleanArraySetting createRemotePBooleanArraySetting(String key, String[] defaultValue, String remoteKey) {
        PBooleanArraySetting result = new PBooleanArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, remoteKey);
        return result;
    }

    public synchronized PasswordSetting createPasswordSettingMD5(String key, String defaultValue) {
        PasswordSetting result = new PasswordSetting(this.DEFAULT_PROPS, this.PROPS, "MD5", key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    private synchronized void handleSettingInternal(AbstractSetting setting, String remoteKey) {
        this.settings.add(setting);
        setting.reload();
        if (remoteKey != null) {
            if (this.remoteKeyToSetting.containsKey(remoteKey)) {
                throw new IllegalArgumentException("duplicate setting remoteKey: " + remoteKey);
            }
            String remoteValue = this.remoteManager.getUnloadedValueFor(remoteKey);
            if (remoteValue != null) {
                setting.setValueInternal(remoteValue);
            } else if (this.REVERT_UNLISTED_REMOTE.getValue()) {
                setting.revertToDefault();
            }
            this.remoteKeyToSetting.put(remoteKey, setting);
        }
    }
}

