/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.statistic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.limewire.collection.Buffer;
import org.limewire.statistic.Statistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatistic
implements Statistic {
    protected final Buffer<Double> _buffer = new Buffer(200);
    protected volatile int _current = 0;
    private volatile int _lastStored = 0;
    protected volatile double _total = 0.0;
    protected volatile int _totalStatsRecorded = 0;
    protected volatile double _max = 0.0;

    @Override
    public double getTotal() {
        return this._total;
    }

    @Override
    public double getAverage() {
        if (this._totalStatsRecorded == 0) {
            return 0.0;
        }
        return this._total / (double)this._totalStatsRecorded;
    }

    @Override
    public double getMax() {
        return this._max;
    }

    @Override
    public int getCurrent() {
        return this._current;
    }

    @Override
    public int getLastStored() {
        return this._lastStored;
    }

    @Override
    public void incrementStat() {
        ++this._current;
        this._total += 1.0;
    }

    @Override
    public void addData(int data) {
        this._current += data;
        this._total += (double)data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer<Double> getStatHistory() {
        Buffer<Double> buffer = this._buffer;
        synchronized (buffer) {
            this.initializeBuffer();
            return this._buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData() {
        this._current = 0;
        this._total = 0.0;
        this._totalStatsRecorded = 0;
        this._max = 0.0;
        Buffer<Double> buffer = this._buffer;
        synchronized (buffer) {
            this._buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCurrentStat() {
        Buffer<Double> buffer = this._buffer;
        synchronized (buffer) {
            this.initializeBuffer();
            this._buffer.addLast(Double.valueOf(this._current));
        }
        if ((double)this._current > this._max) {
            this._max = this._current;
        }
        this._lastStored = this._current;
        this._current = 0;
        ++this._totalStatsRecorded;
    }

    @Override
    public void storeStats(Writer writer) throws IOException {
        writer.write(Integer.toString(this.getCurrent()));
        writer.write("\t");
        writer.write(Double.toString(this.getTotal()));
        writer.write("\t");
        writer.write(Double.toString(this.getAverage()));
        writer.write("\t");
        writer.write(Double.toString(this.getMax()));
        writer.flush();
    }

    protected final void initializeBuffer() {
        if (this._buffer.isEmpty()) {
            for (int i = 0; i < 200; ++i) {
                this._buffer.addLast(Double.NaN);
            }
        }
    }

    @Override
    public Object inspect() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("current", this._current);
        ret.put("lastStored", this._lastStored);
        ret.put("max", Double.doubleToLongBits(this._max));
        ret.put("total", Double.doubleToLongBits(this._total));
        ret.put("recorded", this._totalStatsRecorded);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        try {
            for (Double d : this._buffer) {
                if (Double.isNaN(d)) continue;
                daos.writeDouble(d);
            }
            daos.flush();
            ret.put("buffer", baos.toByteArray());
        }
        catch (IOException impossible) {
            ret.put("impossible", impossible.getMessage());
        }
        return ret;
    }
}

