/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.statistic;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsUtils {
    private StatsUtils() {
    }

    public static DoubleStats quickStatsDouble(List<Double> l) {
        DoubleStats ret = new DoubleStats();
        ret.number = l.size();
        if (ret.number < 2) {
            return ret;
        }
        Collections.sort(l);
        ret.min = l.get(0);
        ret.max = l.get(l.size() - 1);
        ret.med = StatsUtils.getQuartile(Quartile.MED, l);
        if (ret.number > 6) {
            ret.q1 = StatsUtils.getQuartile(Quartile.Q1, l);
            ret.q3 = StatsUtils.getQuartile(Quartile.Q3, l);
        }
        double mode = l.get(0);
        double current = l.get(0);
        int occurences = 0;
        int currentOccurences = 0;
        for (int i = 1; i < l.size(); ++i) {
            if (l.get(i) == current) {
                ++currentOccurences;
            } else {
                current = l.get(i);
                currentOccurences = 0;
            }
            if (currentOccurences <= occurences) continue;
            occurences = currentOccurences;
            mode = current;
        }
        ret.mode = mode;
        double sum = 0.0;
        for (double i : l) {
            sum += i;
        }
        ret.avg = sum / (double)l.size();
        sum = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        for (double i : l) {
            if (i > ret.avg) {
                ret.st += 1.0;
            }
            double dist = i - ret.avg;
            double dist2 = dist * dist;
            double dist3 = dist2 * dist;
            sum += dist2;
            sum3 += dist3;
            sum4 += dist2 * dist2;
        }
        int div = l.size() - 1;
        ret.m2 = sum / (double)div;
        ret.m3 = sum3 / (double)div;
        ret.m4 = sum4 / (double)div;
        double[] swilk = StatsUtils.swilk(l);
        if (swilk != null) {
            ret.swilkW = swilk[0];
            ret.swilkPW = swilk[1];
        }
        return ret;
    }

    private static double getQuartile(Quartile quartile, List<Double> l) {
        int q1i;
        double q1 = (double)(l.size() + 1) * ((double)quartile.getType() / 4.0);
        if (q1 - (double)(q1i = (int)q1) == 0.0) {
            return l.get(q1i - 1);
        }
        double q1a = l.get(q1i - 1);
        double q1b = l.get(q1i);
        q1b -= q1a;
        q1b = q1b * (double)quartile.getType() / 4.0;
        return q1a + q1b;
    }

    public static List<Integer> getHistogram(List<Double> data, int breaks) {
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(breaks);
        for (int i = 0; i < breaks; ++i) {
            ret.add(0);
        }
        double min = Collections.min(data);
        double range = Collections.max(data) - min + 1.0;
        double step = range / (double)breaks;
        for (double point : data) {
            int index = Math.min((int)((point - min) / step), breaks - 1);
            ret.set(index, (Integer)ret.get(index) + 1);
        }
        return ret;
    }

    public static List<Integer> getHistogramBigInt(List<BigInteger> data, int breaks) {
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(breaks);
        for (int i = 0; i < breaks; ++i) {
            ret.add(0);
        }
        BigInteger min = Collections.min(data);
        BigInteger max = Collections.max(data);
        BigInteger range = max.subtract(min).add(BigInteger.valueOf(1L));
        BigInteger step = range.divide(BigInteger.valueOf(breaks));
        if (step.equals(BigInteger.ZERO)) {
            return Collections.emptyList();
        }
        for (BigInteger point : data) {
            int index = point.subtract(min).divide(step).intValue();
            index = Math.min(index, breaks - 1);
            ret.set(index, (Integer)ret.get(index) + 1);
        }
        return ret;
    }

    public static List<Double> rank(List<Double> data) {
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Double> ret = new ArrayList<Double>(data.size());
        if (data.size() == 1) {
            ret.add(1.0);
            return ret;
        }
        Collections.sort(data);
        int i = 0;
        while (i < data.size()) {
            double value = data.get(i);
            double rank = 0.0;
            int j = i;
            while (j < data.size() && data.get(j) == value) {
                rank += (double)(++j);
            }
            if (j == i + 1) {
                ret.add(Double.valueOf(++i));
                continue;
            }
            rank /= (double)(j - i);
            do {
                ret.add(rank);
            } while (++i < j);
        }
        return ret;
    }

    public static double[] swilk(List<Double> d) {
        if (d.size() < 3) {
            return null;
        }
        Collections.sort(d);
        double[] x = new double[d.size() + 1];
        for (int i = 1; i < x.length; ++i) {
            x[i] = d.get(i - 1);
        }
        boolean[] init = new boolean[1];
        double[] a = new double[d.size() + 1];
        double[] w = new double[1];
        double[] pw = new double[1];
        int[] ifault = new int[]{-1};
        SWilk.swilk(init, x, d.size(), d.size(), d.size() / 2, a, w, pw, ifault);
        if (ifault[0] != 0 && ifault[0] != 2) {
            return null;
        }
        return new double[]{w[0], pw[0]};
    }

    private static class SWilk {
        private static final double[] C1 = new double[]{Double.NaN, 0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        private static final double[] C2 = new double[]{Double.NaN, 0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        private static final double[] C3 = new double[]{Double.NaN, 0.544, -0.39978, 0.025054, -6.714E-4};
        private static final double[] C4 = new double[]{Double.NaN, 1.3822, -0.77857, 0.062767, -0.0020322};
        private static final double[] C5 = new double[]{Double.NaN, -1.5861, -0.31082, -0.083751, 0.0038915};
        private static final double[] C6 = new double[]{Double.NaN, -0.4803, -0.082676, 0.0030302};
        private static final double[] C7 = new double[]{Double.NaN, 0.164, 0.533};
        private static final double[] C8 = new double[]{Double.NaN, 0.1736, 0.315};
        private static final double[] C9 = new double[]{Double.NaN, 0.256, -0.00635};
        private static final double[] G = new double[]{Double.NaN, -2.273, 0.459};
        private static final double Z90 = 1.2816;
        private static final double Z95 = 1.6449;
        private static final double Z99 = 2.3263;
        private static final double ZM = 1.7509;
        private static final double ZSS = 0.56268;
        private static final double BF1 = 0.8378;
        private static final double XX90 = 0.556;
        private static final double XX95 = 0.622;
        private static final double SQRTH = 0.70711;
        private static final double TH = 0.375;
        private static final double SMALL = 1.0E-19;
        private static final double PI6 = 1.909859;
        private static final double STQR = 1.047198;
        private static final boolean UPPER = true;
        private static final double A0_p = 3.3871327179;
        private static final double A1_p = 50.434271938;
        private static final double A2_p = 159.29113202;
        private static final double A3_p = 59.10937472;
        private static final double B1_p = 17.895169469;
        private static final double B2_p = 78.757757664;
        private static final double B3_p = 67.1875636;
        private static final double C0_p = 1.4234372777;
        private static final double C1_p = 2.75681539;
        private static final double C2_p = 1.3067284816;
        private static final double C3_p = 0.17023821103;
        private static final double D1_p = 0.7370016425;
        private static final double D2_p = 0.12021132975;
        private static final double E0_p = 6.657905115;
        private static final double E1_p = 3.081226386;
        private static final double E2_p = 0.42868294337;
        private static final double E3_p = 0.017337203997;
        private static final double F1_p = 0.24197894225;
        private static final double F2_p = 0.012258202635;
        private static final double SPLIT1 = 0.425;
        private static final double SPLIT2 = 5.0;
        private static final double CONST1 = 0.180625;
        private static final double CONST2 = 1.6;
        private static final double CON_a = 1.28;
        private static final double LTONE_a = 7.0;
        private static final double UTZERO_a = 18.66;
        private static final double P_a = 0.398942280444;
        private static final double Q_a = 0.39990348504;
        private static final double R_a = 0.398942280385;
        private static final double A1_a = 5.75885480458;
        private static final double A2_a = 2.62433121679;
        private static final double A3_a = 5.92885724438;
        private static final double B1_a = -29.8213557807;
        private static final double B2_a = 48.6959930692;
        private static final double C1_a = -3.8052E-8;
        private static final double C2_a = 3.98064794E-4;
        private static final double C3_a = -0.151679116635;
        private static final double C4_a = 4.8385912808;
        private static final double C5_a = 0.742380924027;
        private static final double C6_a = 3.99019417011;
        private static final double D1_a = 1.00000615302;
        private static final double D2_a = 1.98615381364;
        private static final double D3_a = 5.29330324926;
        private static final double D4_a = -15.1508972451;
        private static final double D5_a = 30.789933034;

        private SWilk() {
        }

        private static void swilk(boolean[] init, double[] x, int n, int n1, int n2, double[] a, double[] w, double[] pw, int[] ifault) {
            double xx;
            double w1;
            pw[0] = 1.0;
            if (w[0] >= 0.0) {
                w[0] = 1.0;
            }
            double an = n;
            ifault[0] = 3;
            int nn2 = n / 2;
            if (n2 < nn2) {
                return;
            }
            ifault[0] = 1;
            if (n < 3) {
                return;
            }
            if (!init[0]) {
                if (n == 3) {
                    a[1] = 0.70711;
                } else {
                    double fac;
                    int i1;
                    double an25 = an + 0.25;
                    double summ2 = 0.0;
                    for (int i = 1; i <= n2; ++i) {
                        a[i] = SWilk.ppnd(((double)i - 0.375) / an25);
                        summ2 += a[i] * a[i];
                    }
                    double ssumm2 = Math.sqrt(summ2 *= 2.0);
                    double rsn = 1.0 / Math.sqrt(an);
                    double a1 = SWilk.poly(C1, 6, rsn) - a[1] / ssumm2;
                    if (n > 5) {
                        i1 = 3;
                        double a2 = -a[2] / ssumm2 + SWilk.poly(C2, 6, rsn);
                        fac = Math.sqrt((summ2 - 2.0 * a[1] * a[1] - 2.0 * a[2] * a[2]) / (1.0 - 2.0 * a1 * a1 - 2.0 * a2 * a2));
                        a[1] = a1;
                        a[2] = a2;
                    } else {
                        i1 = 2;
                        fac = Math.sqrt((summ2 - 2.0 * a[1] * a[1]) / (1.0 - 2.0 * a1 * a1));
                        a[1] = a1;
                    }
                    for (int i = i1; i <= nn2; ++i) {
                        a[i] = -a[i] / fac;
                    }
                }
                init[0] = true;
            }
            if (n1 < 3) {
                return;
            }
            int ncens = n - n1;
            ifault[0] = 4;
            if (ncens < 0 || ncens > 0 && n < 20) {
                return;
            }
            ifault[0] = 5;
            double delta = (double)ncens / an;
            if (delta > 0.8) {
                return;
            }
            if (w[0] < 0.0) {
                w1 = 1.0 + w[0];
                ifault[0] = 0;
            } else {
                ifault[0] = 6;
                double range = x[n1] - x[1];
                if (range < 1.0E-19) {
                    return;
                }
                ifault[0] = 7;
                double sx = xx = x[1] / range;
                double sa = -a[1];
                int j = n - 1;
                for (int i = 2; i <= n1; ++i) {
                    double xi = x[i] / range;
                    sx += xi;
                    if (i != j) {
                        sa += (double)SWilk.sign(1, i - j) * a[Math.min(i, j)];
                    }
                    xx = xi;
                    --j;
                }
                ifault[0] = 0;
                if (n > 5000) {
                    ifault[0] = 2;
                }
                sa /= (double)n1;
                sx /= (double)n1;
                double ssa = 0.0;
                double ssx = 0.0;
                double sax = 0.0;
                j = n;
                for (int i = 1; i <= n1; ++i) {
                    double asa = i != j ? (double)SWilk.sign(1, i - j) * a[Math.min(i, j)] - sa : -sa;
                    double xsx = x[i] / range - sx;
                    ssa += asa * asa;
                    ssx += xsx * xsx;
                    sax += asa * xsx;
                    --j;
                }
                double ssassx = Math.sqrt(ssa * ssx);
                w1 = (ssassx - sax) * (ssassx + sax) / (ssa * ssx);
            }
            w[0] = 1.0 - w1;
            if (n == 3) {
                pw[0] = 1.909859 * (Math.asin(Math.sqrt(w[0])) - 1.047198);
                return;
            }
            double y = Math.log(w1);
            xx = Math.log(an);
            double m = 0.0;
            double s = 1.0;
            if (n <= 11) {
                double gamma = SWilk.poly(G, 2, an);
                if (y >= gamma) {
                    pw[0] = 1.0E-19;
                    return;
                }
                y = -Math.log(gamma - y);
                m = SWilk.poly(C3, 4, an);
                s = Math.exp(SWilk.poly(C4, 4, an));
            } else {
                m = SWilk.poly(C5, 4, xx);
                s = Math.exp(SWilk.poly(C6, 3, xx));
            }
            if (ncens > 0) {
                double ld = -Math.log(delta);
                double bf = 1.0 + xx * 0.8378;
                double z90f = 1.2816 + bf * Math.pow(SWilk.poly(C7, 2, Math.pow(0.556, xx)), ld);
                double z95f = 1.6449 + bf * Math.pow(SWilk.poly(C8, 2, Math.pow(0.622, xx)), ld);
                double z99f = 2.3263 + bf * Math.pow(SWilk.poly(C9, 2, xx), ld);
                double zfm = (z90f + z95f + z99f) / 3.0;
                double zsd = (1.2816 * (z90f - zfm) + 1.6449 * (z95f - zfm) + 2.3263 * (z99f - zfm)) / 0.56268;
                double zbar = zfm - zsd * 1.7509;
                m += zbar * s;
                s *= zsd;
            }
            pw[0] = SWilk.alnorm((y - m) / s, true);
        }

        private static int sign(int x, int y) {
            int result = Math.abs(x);
            if ((double)y < 0.0) {
                result = -result;
            }
            return result;
        }

        private static double ppnd(double p) {
            double q = p - 0.5;
            if (Math.abs(q) <= 0.425) {
                double r = 0.180625 - q * q;
                return q * (((59.10937472 * r + 159.29113202) * r + 50.434271938) * r + 3.3871327179) / (((67.1875636 * r + 78.757757664) * r + 17.895169469) * r + 1.0);
            }
            double r = q < 0.0 ? p : 1.0 - p;
            if (r <= 0.0) {
                return 0.0;
            }
            double normal_dev = (r = Math.sqrt(-Math.log(r))) <= 5.0 ? (((0.17023821103 * (r -= 1.6) + 1.3067284816) * r + 2.75681539) * r + 1.4234372777) / ((0.12021132975 * r + 0.7370016425) * r + 1.0) : (((0.017337203997 * (r -= 5.0) + 0.42868294337) * r + 3.081226386) * r + 6.657905115) / ((0.012258202635 * r + 0.24197894225) * r + 1.0);
            if (q < 0.0) {
                normal_dev = -normal_dev;
            }
            return normal_dev;
        }

        private static double poly(double[] c, int nord, double x) {
            double poly = c[1];
            if (nord == 1) {
                return poly;
            }
            double p = x * c[nord];
            if (nord != 2) {
                int n2 = nord - 2;
                int j = n2 + 1;
                for (int i = 1; i <= n2; ++i) {
                    p = (p + c[j]) * x;
                    --j;
                }
            }
            return poly += p;
        }

        private static double alnorm(double x, boolean upper) {
            double fn_val;
            boolean up = upper;
            double z = x;
            if (z < 0.0) {
                up = !up;
                z = -z;
            }
            if (z > 7.0 && (!up || z > 18.66)) {
                fn_val = 0.0;
            } else {
                double y = 0.5 * z * z;
                fn_val = z <= 1.28 ? 0.5 - z * (0.398942280444 - 0.39990348504 * y / (y + 5.75885480458 + -29.8213557807 / (y + 2.62433121679 + 48.6959930692 / (y + 5.92885724438)))) : 0.398942280385 * Math.exp(-y) / (z + -3.8052E-8 + 1.00000615302 / (z + 3.98064794E-4 + 1.98615381364 / (z + -0.151679116635 + 5.29330324926 / (z + 4.8385912808 + -15.1508972451 / (z + 0.742380924027 + 30.789933034 / (z + 3.99019417011))))));
            }
            if (!up) {
                fn_val = 1.0 - fn_val;
            }
            return fn_val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleStats
    extends Stats {
        public double min;
        public double max;
        public double med;
        public double q1;
        public double q3;
        public double avg;
        public double m2;
        public double m3;
        public double m4;
        public double mode;
        public double st;
        public double swilkW;
        public double swilkPW;

        DoubleStats() {
        }

        @Override
        protected void addAnySpecifics(Map<String, Object> m) {
            m.put("swilkW", this.doubleToBytes(this.swilkW));
            m.put("swilkPW", this.doubleToBytes(this.swilkPW));
        }

        @Override
        public Object getMin() {
            return this.doubleToBytes(this.min);
        }

        @Override
        public Object getMax() {
            return this.doubleToBytes(this.max);
        }

        @Override
        public Object getMed() {
            return this.doubleToBytes(this.med);
        }

        @Override
        public Object getQ1() {
            return this.doubleToBytes(this.q1);
        }

        @Override
        public Object getQ3() {
            return this.doubleToBytes(this.q3);
        }

        @Override
        public Object getAvg() {
            return this.doubleToBytes(this.avg);
        }

        @Override
        public Object getM2() {
            return this.doubleToBytes(this.m2);
        }

        @Override
        public Object getM3() {
            return this.doubleToBytes(this.m3);
        }

        @Override
        public Object getM4() {
            return this.doubleToBytes(this.m4);
        }

        @Override
        public Object getMode() {
            return this.doubleToBytes(this.mode);
        }

        @Override
        public Object getST() {
            return this.doubleToBytes(this.st);
        }

        private byte[] doubleToBytes(double f) {
            byte[] writeBuffer = new byte[4];
            int v = Float.floatToIntBits((float)f);
            writeBuffer[0] = (byte)(v >>> 24);
            writeBuffer[1] = (byte)(v >>> 16);
            writeBuffer[2] = (byte)(v >>> 8);
            writeBuffer[3] = (byte)(v >>> 0);
            return writeBuffer;
        }

        public static double bytesToDouble(byte[] b) {
            if (b == null) {
                return Double.NaN;
            }
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
            try {
                if (b.length == 4) {
                    return dis.readFloat();
                }
                return dis.readDouble();
            }
            catch (IOException bad) {
                return Double.NaN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Stats {
        private static final int VERSION = 1;
        int number;

        public final Map<String, Object> getMap() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ver", 1);
            ret.put("num", this.number);
            if (this.number < 2) {
                return ret;
            }
            ret.put("min", this.getMin());
            ret.put("max", this.getMax());
            ret.put("med", this.getMed());
            ret.put("avg", this.getAvg());
            ret.put("M2", this.getM2());
            ret.put("M3", this.getM3());
            ret.put("M4", this.getM4());
            ret.put("mode", this.getMode());
            ret.put("st", this.getST());
            if (this.number > 6) {
                ret.put("Q1", this.getQ1());
                ret.put("Q3", this.getQ3());
            }
            this.addAnySpecifics(ret);
            return ret;
        }

        protected void addAnySpecifics(Map<String, Object> ret) {
        }

        public final Map<String, Object> getTTestMap() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ver", 1);
            ret.put("num", this.number);
            if (this.number < 2) {
                return ret;
            }
            ret.put("avg", this.getAvg());
            ret.put("M2", this.getM2());
            return ret;
        }

        public final int getNumber() {
            return this.number;
        }

        public abstract Object getMin();

        public abstract Object getMax();

        public abstract Object getMed();

        public abstract Object getAvg();

        public abstract Object getQ1();

        public abstract Object getQ3();

        public abstract Object getM2();

        public abstract Object getM3();

        public abstract Object getM4();

        public abstract Object getMode();

        public abstract Object getST();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Quartile {
        Q1(1),
        MED(2),
        Q3(3);

        private final int type;

        private Quartile(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

