/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteUtils {
    public static byte[] reverse(byte[] x) {
        int n = x.length;
        if (n > 0) {
            byte[] ret = new byte[n];
            int i = 0;
            int j = n - 1;
            while (j >= 0) {
                ret[i++] = x[j--];
            }
            return ret;
        }
        return x;
    }

    private static int readByte(InputStream is) throws IOException {
        int ret = is.read();
        if (ret == -1) {
            throw new EOFException();
        }
        return ret;
    }

    public static short leb2short(byte[] x, int offset) {
        return (short)(x[offset] & 0xFF | x[offset + 1] << 8);
    }

    public static short beb2short(byte[] x, int offset) {
        return (short)(x[offset] << 8 | x[offset + 1] & 0xFF);
    }

    public static short leb2short(InputStream is) throws IOException {
        return (short)(ByteUtils.readByte(is) & 0xFF | ByteUtils.readByte(is) << 8);
    }

    public static short beb2short(InputStream is) throws IOException {
        return (short)(ByteUtils.readByte(is) << 8 | ByteUtils.readByte(is) & 0xFF);
    }

    public static int leb2int(byte[] x, int offset) {
        return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16 | x[offset + 3] << 24;
    }

    public static int beb2int(byte[] x, int offset) {
        return x[offset] << 24 | (x[offset + 1] & 0xFF) << 16 | (x[offset + 2] & 0xFF) << 8 | x[offset + 3] & 0xFF;
    }

    public static int leb2int(InputStream is) throws IOException {
        return ByteUtils.readByte(is) & 0xFF | (ByteUtils.readByte(is) & 0xFF) << 8 | (ByteUtils.readByte(is) & 0xFF) << 16 | ByteUtils.readByte(is) << 24;
    }

    public static int beb2int(InputStream is) throws IOException {
        return ByteUtils.readByte(is) << 24 | (ByteUtils.readByte(is) & 0xFF) << 16 | (ByteUtils.readByte(is) & 0xFF) << 8 | ByteUtils.readByte(is) & 0xFF;
    }

    public static int leb2int(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return x[offset] & 0xFF;
            }
            case 2: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8;
            }
            case 3: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16;
            }
            case 4: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16 | x[offset + 3] << 24;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static long leb2long(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return (long)x[offset] & 0xFFL;
            }
            case 2: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8;
            }
            case 3: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16;
            }
            case 4: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24;
            }
            case 5: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24 | ((long)x[offset + 4] & 0xFFL) << 32;
            }
            case 6: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24 | ((long)x[offset + 4] & 0xFFL) << 32 | ((long)x[offset + 5] & 0xFFL) << 40;
            }
            case 7: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24 | ((long)x[offset + 4] & 0xFFL) << 32 | ((long)x[offset + 5] & 0xFFL) << 40 | ((long)x[offset + 6] & 0xFFL) << 48;
            }
            case 8: {
                return (long)x[offset] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24 | ((long)x[offset + 4] & 0xFFL) << 32 | ((long)x[offset + 5] & 0xFFL) << 40 | ((long)x[offset + 6] & 0xFFL) << 48 | (long)x[offset + 7] << 56;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static long leb2long(InputStream is) throws IOException {
        return (long)ByteUtils.readByte(is) & 0xFFL | ((long)ByteUtils.readByte(is) & 0xFFL) << 8 | ((long)ByteUtils.readByte(is) & 0xFFL) << 16 | ((long)ByteUtils.readByte(is) & 0xFFL) << 24 | ((long)ByteUtils.readByte(is) & 0xFFL) << 32 | ((long)ByteUtils.readByte(is) & 0xFFL) << 40 | ((long)ByteUtils.readByte(is) & 0xFFL) << 48 | (long)(ByteUtils.readByte(is) << 56);
    }

    public static int beb2int(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return x[offset] & 0xFF;
            }
            case 2: {
                return (x[offset] & 0xFF) << 8 | x[offset + 1] & 0xFF;
            }
            case 3: {
                return (x[offset] & 0xFF) << 16 | (x[offset + 1] & 0xFF) << 8 | x[offset + 2] & 0xFF;
            }
            case 4: {
                return x[offset] << 24 | (x[offset + 1] & 0xFF) << 16 | (x[offset + 2] & 0xFF) << 8 | x[offset + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static void short2leb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)x;
        buf[offset + 1] = (byte)(x >> 8);
    }

    public static void short2beb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)(x >> 8);
        buf[offset + 1] = (byte)x;
    }

    public static void short2leb(short x, OutputStream os) throws IOException {
        os.write((byte)x);
        os.write((byte)(x >> 8));
    }

    public static void short2beb(short x, OutputStream os) throws IOException {
        os.write((byte)(x >> 8));
        os.write((byte)x);
    }

    public static void int2leb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)x;
        buf[offset + 1] = (byte)(x >> 8);
        buf[offset + 2] = (byte)(x >> 16);
        buf[offset + 3] = (byte)(x >> 24);
    }

    public static void long2beb(long x, byte[] buf, int offset) {
        buf[offset] = (byte)(x >> 56);
        buf[offset + 1] = (byte)(x >> 48);
        buf[offset + 2] = (byte)(x >> 40);
        buf[offset + 3] = (byte)(x >> 32);
        buf[offset + 4] = (byte)(x >> 24);
        buf[offset + 5] = (byte)(x >> 16);
        buf[offset + 6] = (byte)(x >> 8);
        buf[offset + 7] = (byte)x;
    }

    public static void long2leb(long x, byte[] buf, int offset) {
        buf[offset] = (byte)x;
        buf[offset + 1] = (byte)(x >> 8);
        buf[offset + 2] = (byte)(x >> 16);
        buf[offset + 3] = (byte)(x >> 24);
        buf[offset + 4] = (byte)(x >> 32);
        buf[offset + 5] = (byte)(x >> 40);
        buf[offset + 6] = (byte)(x >> 48);
        buf[offset + 7] = (byte)(x >> 56);
    }

    public static byte[] long2bytes(long i, int byteCount) {
        byte[] b = new byte[8];
        b[7] = (byte)i;
        b[6] = (byte)(i >>>= 8);
        b[5] = (byte)(i >>>= 8);
        b[4] = (byte)(i >>>= 8);
        b[3] = (byte)(i >>>= 8);
        b[2] = (byte)(i >>>= 8);
        b[1] = (byte)(i >>>= 8);
        b[0] = (byte)(i >>>= 8);
        byte[] bytes = new byte[byteCount];
        System.arraycopy(b, 8 - byteCount, bytes, 0, byteCount);
        return bytes;
    }

    public static void int2beb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)(x >> 24);
        buf[offset + 1] = (byte)(x >> 16);
        buf[offset + 2] = (byte)(x >> 8);
        buf[offset + 3] = (byte)x;
    }

    public static void int2beb(int x, OutputStream out, int n) throws IOException {
        switch (n) {
            case 1: {
                out.write((byte)x);
                break;
            }
            case 2: {
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            case 3: {
                out.write((byte)(x >> 16));
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            case 4: {
                out.write((byte)(x >> 24));
                out.write((byte)(x >> 16));
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid n: " + n);
            }
        }
    }

    public static void int2leb(int x, OutputStream os) throws IOException {
        os.write((byte)x);
        os.write((byte)(x >> 8));
        os.write((byte)(x >> 16));
        os.write((byte)(x >> 24));
    }

    public static void int2beb(int x, OutputStream os) throws IOException {
        os.write((byte)(x >> 24));
        os.write((byte)(x >> 16));
        os.write((byte)(x >> 8));
        os.write((byte)x);
    }

    public static byte[] int2minLeb(int x) throws IllegalArgumentException {
        if (x <= 65535) {
            if (x <= 255) {
                if (x < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)x};
            }
            return new byte[]{(byte)x, (byte)(x >> 8)};
        }
        if (x <= 0xFFFFFF) {
            return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16)};
        }
        return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24)};
    }

    public static byte[] long2minLeb(long x) throws IllegalArgumentException {
        if (x <= 0xFFFFFFFFFFFFFFL) {
            if (x <= 0xFFFFFFFFFFFFL) {
                if (x <= 0xFFFFFFFFFFL) {
                    if (x <= 0xFFFFFFFFL) {
                        if (x <= 0xFFFFFFL) {
                            if (x <= 65535L) {
                                if (x <= 255L) {
                                    if (x < 0L) {
                                        throw new IllegalArgumentException();
                                    }
                                    return new byte[]{(byte)x};
                                }
                                return new byte[]{(byte)x, (byte)(x >> 8)};
                            }
                            return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16)};
                        }
                        return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24)};
                    }
                    return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24), (byte)(x >> 32)};
                }
                return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24), (byte)(x >> 32), (byte)(x >> 40)};
            }
            return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24), (byte)(x >> 32), (byte)(x >> 40), (byte)(x >> 48)};
        }
        return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24), (byte)(x >> 32), (byte)(x >> 40), (byte)(x >> 48), (byte)(x >> 56)};
    }

    public static byte[] int2minBeb(int x) throws IllegalArgumentException {
        if (x <= 65535) {
            if (x <= 255) {
                if (x < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)x};
            }
            return new byte[]{(byte)(x >> 8), (byte)x};
        }
        if (x <= 0xFFFFFF) {
            return new byte[]{(byte)(x >> 16), (byte)(x >> 8), (byte)x};
        }
        return new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)x};
    }

    public static int ubyte2int(byte x) {
        return x & 0xFF;
    }

    public static int ushort2int(short x) {
        return x & 0xFFFF;
    }

    public static long uint2long(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        int m = Integer.MAX_VALUE;
        if (l < (long)Integer.MAX_VALUE) {
            m = Integer.MIN_VALUE;
            if (l > (long)Integer.MIN_VALUE) {
                return (int)l;
            }
        }
        return m;
    }

    public static long beb2long(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return (long)x[offset] & 0xFFL;
            }
            case 2: {
                return (long)x[offset + 1] & 0xFFL | ((long)x[offset] & 0xFFL) << 8;
            }
            case 3: {
                return (long)x[offset + 2] & 0xFFL | ((long)x[offset + 1] & 0xFFL) << 8 | ((long)x[offset] & 0xFFL) << 16;
            }
            case 4: {
                return (long)x[offset + 3] & 0xFFL | ((long)x[offset + 2] & 0xFFL) << 8 | ((long)x[offset + 1] & 0xFFL) << 16 | ((long)x[offset] & 0xFFL) << 24;
            }
            case 5: {
                return (long)x[offset + 4] & 0xFFL | ((long)x[offset + 3] & 0xFFL) << 8 | ((long)x[offset + 2] & 0xFFL) << 16 | ((long)x[offset + 1] & 0xFFL) << 24 | ((long)x[offset] & 0xFFL) << 32;
            }
            case 6: {
                return (long)x[offset + 5] & 0xFFL | ((long)x[offset + 4] & 0xFFL) << 8 | ((long)x[offset + 3] & 0xFFL) << 16 | ((long)x[offset + 2] & 0xFFL) << 24 | ((long)x[offset + 1] & 0xFFL) << 32 | ((long)x[offset] & 0xFFL) << 40;
            }
            case 7: {
                return (long)x[offset + 6] & 0xFFL | ((long)x[offset + 5] & 0xFFL) << 8 | ((long)x[offset + 4] & 0xFFL) << 16 | ((long)x[offset + 3] & 0xFFL) << 24 | ((long)x[offset + 2] & 0xFFL) << 32 | ((long)x[offset + 1] & 0xFFL) << 40 | ((long)x[offset] & 0xFFL) << 48;
            }
            case 8: {
                return (long)x[offset + 7] & 0xFFL | ((long)x[offset + 6] & 0xFFL) << 8 | ((long)x[offset + 5] & 0xFFL) << 16 | ((long)x[offset + 4] & 0xFFL) << 24 | ((long)x[offset + 3] & 0xFFL) << 32 | ((long)x[offset + 2] & 0xFFL) << 40 | ((long)x[offset + 1] & 0xFFL) << 48 | ((long)x[offset] & 0xFFL) << 56;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }
}

