/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

public class CommonUtils {
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static volatile File settingsDirectory = null;

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static InputStream getResourceStream(String location) throws IOException {
        ClassLoader cl = CommonUtils.class.getClassLoader();
        URL resource = null;
        resource = cl == null ? ClassLoader.getSystemResource(location) : cl.getResource(location);
        if (resource == null) {
            throw new IOException("null resource: " + location);
        }
        return resource.openStream();
    }

    public static String decode(String s) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(s);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            result = new String(inputBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static void copyResourceFile(String fileName, File newFile, boolean forceOverwrite) throws IOException {
        ClassLoader cl;
        URL resource;
        if (newFile == null) {
            newFile = new File(".", fileName);
        }
        if (!forceOverwrite && newFile.exists()) {
            return;
        }
        String parentString = newFile.getParent();
        if (parentString == null) {
            return;
        }
        File parentFile = new File(parentString);
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        URL uRL = resource = (cl = CommonUtils.class.getClassLoader()) != null ? cl.getResource(fileName) : ClassLoader.getSystemResource(fileName);
        if (resource == null) {
            throw new IOException("resource: " + fileName + " doesn't exist.");
        }
        CommonUtils.saveStream(resource.openStream(), newFile);
    }

    public static void copyFile(File src, File dst) throws IOException {
        CommonUtils.saveStream(new FileInputStream(src), dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStream(InputStream inStream, File newFile) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bufferSize = 2048;
            bis = new BufferedInputStream(inStream, 2048);
            bos = new BufferedOutputStream(new FileOutputStream(newFile), 2048);
            byte[] buffer = new byte[2048];
            int c = 0;
            do {
                if ((c = bis.read(buffer, 0, 2048)) <= 0) continue;
                ((BufferedOutputStream)bos).write(buffer, 0, c);
            } while (c == 2048);
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException e) {
            newFile.delete();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignored) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static String getAllStackTraces() {
        try {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            ArrayList<Map.Entry<Thread, StackTraceElement[]>> sorted = new ArrayList<Map.Entry<Thread, StackTraceElement[]>>(map.entrySet());
            Collections.sort(sorted, new Comparator<Map.Entry<Thread, StackTraceElement[]>>(){

                @Override
                public int compare(Map.Entry<Thread, StackTraceElement[]> a, Map.Entry<Thread, StackTraceElement[]> b) {
                    return a.getKey().getName().compareTo(b.getKey().getName());
                }
            });
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry entry : sorted) {
                Thread key = (Thread)entry.getKey();
                StackTraceElement[] value = (StackTraceElement[])entry.getValue();
                buffer.append(key.getName()).append("\n");
                for (int i = 0; i < value.length; ++i) {
                    buffer.append("    ").append(value[i]).append("\n");
                }
                buffer.append("\n");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            return buffer.toString();
        }
        catch (Exception err) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("An error occured during getting the StackTraces of all active Threads");
            err.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
    }

    public static String seconds2time(int seconds) {
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        int days = hours / 24;
        hours -= days * 24;
        StringBuilder time = new StringBuilder();
        if (days != 0) {
            time.append(Integer.toString(days));
            time.append(":");
            if (hours < 10) {
                time.append("0");
            }
        }
        if (days != 0 || hours != 0) {
            time.append(Integer.toString(hours));
            time.append(":");
            if (minutes < 10) {
                time.append("0");
            }
        }
        time.append(Integer.toString(minutes));
        time.append(":");
        if (seconds < 10) {
            time.append("0");
        }
        time.append(Integer.toString(seconds));
        return time.toString();
    }

    public static String convertFileName(File parentDir, String name) throws IOException {
        int parentLength = parentDir.getAbsolutePath().getBytes(Charset.defaultCharset().name()).length;
        if (parentLength >= OSUtils.getMaxPathLength() - 1) {
            throw new IOException("Path too long");
        }
        return CommonUtils.convertFileName(name, Math.min(OSUtils.getMaxPathLength() - parentLength - 1, 180));
    }

    public static String convertFileName(String name) {
        return CommonUtils.convertFileName(name, 180);
    }

    public static String convertFileName(String name, int maxBytes) {
        try {
            return CommonUtils.convertFileName(name, maxBytes, Charset.defaultCharset());
        }
        catch (CharacterCodingException cce) {
            try {
                return CommonUtils.convertFileName(name, maxBytes, Charset.forName("UTF-8"));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("UTF-8 should have encoded: " + name, e);
            }
        }
    }

    public static String convertFileName(String name, int maxBytes, Charset charSet) throws CharacterCodingException {
        block11: {
            int i;
            block12: {
                block10: {
                    if (maxBytes <= 0) {
                        throw new IllegalArgumentException("maxBytes must be > 0");
                    }
                    name = I18NConvert.instance().compose(name);
                    if (name.length() > maxBytes || name.getBytes().length > maxBytes) {
                        int extStart = name.lastIndexOf(46);
                        if (extStart == -1) {
                            name = CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet);
                        } else {
                            int extLength = name.length() - extStart;
                            int extEnd = extLength > 11 ? extStart + 11 : name.length();
                            byte[] extension = CommonUtils.getMaxBytes(name.substring(extStart, extEnd), 16, charSet);
                            try {
                                name = extension.length >= maxBytes - 10 ? CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet) : CommonUtils.getPrefixWithMaxBytes(name, maxBytes - extension.length, charSet) + new String(extension, charSet.name());
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("Could not handle string", uee);
                            }
                        }
                    }
                    for (i = 0; i < ILLEGAL_CHARS_ANY_OS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_ANY_OS[i], '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block10;
                    for (i = 0; i < ILLEGAL_CHARS_WINDOWS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_WINDOWS[i], '_');
                    }
                    break block11;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block12;
                for (i = 0; i < ILLEGAL_CHARS_UNIX.length; ++i) {
                    name = name.replace(ILLEGAL_CHARS_UNIX[i], '_');
                }
                break block11;
            }
            if (!OSUtils.isMacOSX()) break block11;
            for (i = 0; i < ILLEGAL_CHARS_MACOS.length; ++i) {
                name = name.replace(ILLEGAL_CHARS_MACOS[i], '_');
            }
        }
        return name;
    }

    public static String santizeString(String name) {
        block5: {
            int i;
            block6: {
                block4: {
                    for (i = 0; i < ILLEGAL_CHARS_ANY_OS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_ANY_OS[i], '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block4;
                    for (i = 0; i < ILLEGAL_CHARS_WINDOWS.length; ++i) {
                        name = name.replace(ILLEGAL_CHARS_WINDOWS[i], '_');
                    }
                    break block5;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block6;
                for (i = 0; i < ILLEGAL_CHARS_UNIX.length; ++i) {
                    name = name.replace(ILLEGAL_CHARS_UNIX[i], '_');
                }
                break block5;
            }
            if (!OSUtils.isMacOSX()) break block5;
            for (i = 0; i < ILLEGAL_CHARS_MACOS.length; ++i) {
                name = name.replace(ILLEGAL_CHARS_MACOS[i], '_');
            }
        }
        return name;
    }

    static String getPrefixWithMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        try {
            return new String(CommonUtils.getMaxBytes(string, maxBytes, charSet), charSet.name());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Could not recreate string", uee);
        }
    }

    static byte[] getMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        byte[] bytes = new byte[maxBytes];
        ByteBuffer out = ByteBuffer.wrap(bytes);
        CharBuffer in = CharBuffer.wrap(string.toCharArray());
        CharsetEncoder encoder = charSet.newEncoder();
        CoderResult cr = encoder.encode(in, out, true);
        encoder.flush(out);
        if (cr.isError()) {
            cr.throwException();
        }
        byte[] result = new byte[out.position()];
        System.arraycopy(bytes, 0, result, 0, result.length);
        return result;
    }

    public static File getCurrentDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static File validateSettingsDirectory(File dir) throws IOException {
        if (!(dir = dir.getAbsoluteFile()).isDirectory()) {
            dir.delete();
            if (!dir.mkdirs()) {
                throw new IOException("could not create preferences directory: " + dir);
            }
        }
        if (!dir.canWrite()) {
            throw new IOException("settings dir not writable: " + dir);
        }
        if (!dir.canRead()) {
            throw new IOException("settings dir not readable: " + dir);
        }
        File file = File.createTempFile("test", "test", dir);
        if (!file.exists()) {
            throw new IOException("can't write test file in directory: " + dir);
        }
        file.delete();
        return dir;
    }

    public static void setUserSettingsDir(File settingsDir) throws IOException {
        if (settingsDirectory != null) {
            throw new IllegalStateException("settings directory already set!");
        }
        settingsDirectory = CommonUtils.validateSettingsDirectory(settingsDir);
    }

    public static synchronized File getUserSettingsDir() {
        if (settingsDirectory != null) {
            return settingsDirectory;
        }
        return CommonUtils.getUserHomeDir();
    }
}

