/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConverterObjectInputStream
extends ObjectInputStream {
    private static final Log LOG = LogFactory.getLog(ConverterObjectInputStream.class);
    private Map<String, String> lookups = new HashMap<String, String>(8);

    public ConverterObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.createLookups();
    }

    public void revertToDefault() {
        this.lookups.clear();
        this.createLookups();
    }

    private void createLookups() {
        this.lookups.put("com.limegroup.gnutella.util.FileComparator", "org.limewire.collection.FileComparator");
        this.lookups.put("com.limegroup.gnutella.util.Comparators$CaseInsensitiveStringComparator", "org.limewire.collection.Comparators$CaseInsensitiveStringComparator");
        this.lookups.put("com.limegroup.gnutella.util.StringComparator", "org.limewire.collection.StringComparator");
        this.lookups.put("com.sun.java.util.collections", "java.util");
    }

    public void addLookup(String oldName, String newName) {
        this.lookups.put(oldName, newName);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int index;
        String oldPackage;
        String newPackage;
        String newName;
        boolean array;
        ObjectStreamClass read = super.readClassDescriptor();
        String className = read.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up class: " + className);
        }
        boolean bl = array = className.startsWith("[L") && className.endsWith(";");
        if (array) {
            className = className.substring(2, className.length() - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stripping array form off, resulting in: " + className);
            }
        }
        ObjectStreamClass clazzToReturn = (newName = this.lookups.get(className)) != null ? ObjectStreamClass.lookup(Class.forName(newName)) : ((newPackage = this.lookups.get(oldPackage = (index = className.lastIndexOf(46)) != -1 ? className.substring(0, index) : "")) != null ? (newPackage.length() == 0 ? ObjectStreamClass.lookup(Class.forName(className.substring(index + 1))) : ObjectStreamClass.lookup(Class.forName(newPackage + '.' + className.substring(index + 1)))) : read);
        if (LOG.isDebugEnabled() && clazzToReturn != read) {
            LOG.debug("Located substitute class: " + clazzToReturn.getName());
        }
        if (array && read != clazzToReturn) {
            clazzToReturn = ObjectStreamClass.lookup(Class.forName("[L" + clazzToReturn.getName() + ";"));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Re-added array wrapper, for class: " + clazzToReturn.getName());
            }
        }
        return clazzToReturn;
    }
}

