/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileLocker;
import org.limewire.util.OSUtils;
import org.limewire.util.ProcessUtils;
import org.limewire.util.SystemUtils;

public class FileUtils {
    private static final Log LOG = LogFactory.getLog(FileUtils.class);
    private static final CopyOnWriteArrayList<FileLocker> fileLockers = new CopyOnWriteArrayList();

    public static void writeObject(String fileName, Object obj) throws IOException {
        FileUtils.writeObject(new File(fileName), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File f, Object obj) throws IOException {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException tryAnyway) {
            // empty catch block
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.writeObject(obj);
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    public static Object readObject(String fileName) throws IOException, ClassNotFoundException {
        return FileUtils.readObject(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException tryAnyway) {
            // empty catch block
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = in.readObject();
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close(in);
        return object;
    }

    public static String getCanonicalPath(File f) throws IOException {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsolutePath();
            }
            throw ioe;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsoluteFile();
            }
            throw ioe;
        }
    }

    public static final boolean isAncestor(File a, File b) {
        while (b != null) {
            if (b.equals(a)) {
                return true;
            }
            b = b.getParentFile();
        }
        return false;
    }

    public static final boolean isReallyParent(File testParent, File testChild) throws IOException {
        String testChildParentName;
        String testParentName = FileUtils.getCanonicalPath(testParent);
        return testParentName.equals(testChildParentName = FileUtils.getCanonicalPath(testChild.getAbsoluteFile().getParentFile()));
    }

    public static final boolean isReallyInParentPath(File testParent, File testChild) throws IOException {
        String testParentName = FileUtils.getCanonicalPath(testParent);
        File testChildParentFile = testChild.getAbsoluteFile().getParentFile();
        if (testChildParentFile == null) {
            testChildParentFile = testChild.getAbsoluteFile();
        }
        String testChildParentName = FileUtils.getCanonicalPath(testChildParentFile);
        return testChildParentName.startsWith(testParentName);
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        return FileUtils.getFileExtension(name);
    }

    public static String getFileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        if (index == name.length() - 1) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (f.canWrite()) {
            if (OSUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        String[] cmds = null;
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            SystemUtils.setWriteable(fName);
        } else if (!OSUtils.isOS2()) {
            cmds = f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName};
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return f.canWrite();
    }

    public static void touch(File f) throws IOException {
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            f.createNewFile();
        }
        catch (IOException failed) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
            }
            catch (IOException ioe) {
                try {
                    ioe.initCause(failed);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    FileUtils.close(fos);
                    throw throwable;
                }
            }
            FileUtils.close(fos);
        }
    }

    public static void addFileLocker(FileLocker locker) {
        fileLockers.addIfAbsent(locker);
    }

    public static void removeFileLocker(FileLocker locker) {
        fileLockers.remove(locker);
    }

    public static boolean forceRename(File src, File dst) {
        boolean success = src.renameTo(dst);
        if (!success) {
            FileLocker locker;
            Iterator<FileLocker> i$ = fileLockers.iterator();
            while (!(!i$.hasNext() || (locker = i$.next()).releaseLock(src) && (success = src.renameTo(dst)))) {
            }
        }
        if (!success && (success = FileUtils.copy(src, dst))) {
            src.delete();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verySafeSave(File dir, String name, byte[] data) {
        File tmp;
        try {
            tmp = FileUtils.createTempFile(name, "tmp", dir);
        }
        catch (IOException hrorible) {
            return false;
        }
        File out = new File(dir, name);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)os).write(data);
            ((OutputStream)os).flush();
            FileUtils.close(os);
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.close(os);
        }
        byte[] read = FileUtils.readFileFully(tmp);
        if (read == null || !Arrays.equals(read, data)) {
            return false;
        }
        return FileUtils.forceRename(tmp, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileFully(File source) {
        DataInputStream raf = null;
        int length = (int)source.length();
        if (length <= 0) {
            return null;
        }
        byte[] data = new byte[length];
        try {
            raf = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
            raf.readFully(data);
            FileUtils.close(raf);
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            FileUtils.close(raf);
        }
        return data;
    }

    public static File[] getFilesRecursive(File directory, String[] filter) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> retFileArray = new ArrayList<File>();
        File[] retArray = new File[]{};
        if (directory.exists() && directory.isDirectory()) {
            dirs.add(directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            String[] listedFiles = currDir.list();
            for (int i = 0; listedFiles != null && i < listedFiles.length; ++i) {
                File currFile = new File(currDir, listedFiles[i]);
                if (currFile.isDirectory()) {
                    dirs.add(currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null) {
                    shouldAdd = true;
                } else {
                    String ext = FileUtils.getFileExtension(currFile);
                    for (int j = 0; j < filter.length && ext != null; ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add(currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = (File)retFileArray.get(i);
            }
        }
        return retArray;
    }

    public static boolean delete(File file, boolean moveToTrash) {
        if (!file.exists()) {
            return false;
        }
        if (moveToTrash) {
            if (OSUtils.isMacOSX()) {
                return FileUtils.moveToTrashOSX(file);
            }
            if (OSUtils.isWindows()) {
                return SystemUtils.recycle(file);
            }
            throw new IllegalArgumentException("OS does not support trash");
        }
        return FileUtils.deleteRecursive(file);
    }

    private static boolean moveToTrashOSX(File file) {
        try {
            String[] command = FileUtils.moveToTrashCommand(file);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream();
            Process process = builder.start();
            ProcessUtils.consumeAllInput(process);
            process.waitFor();
        }
        catch (InterruptedException err) {
            LOG.error("InterruptedException", err);
        }
        catch (IOException err) {
            LOG.error("IOException", err);
        }
        return !file.exists();
    }

    private static String[] moveToTrashCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            LOG.error("IOException", err);
            path = file.getAbsolutePath();
        }
        String fileOrFolder = file.isFile() ? "file" : "folder";
        String[] command = new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "if " + fileOrFolder + " hfsPath exists then", "-e", "move " + fileOrFolder + " hfsPath to trash", "-e", "end if", "-e", "end tell"};
        return command;
    }

    public static boolean deleteRecursive(File directory) {
        String canonicalParent;
        try {
            canonicalParent = FileUtils.getCanonicalPath(directory);
        }
        catch (IOException ioe) {
            return false;
        }
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (!FileUtils.getCanonicalPath(files[i]).startsWith(canonicalParent)) {
                    continue;
                }
            }
            catch (IOException ioe) {
                return false;
            }
            if (FileUtils.deleteRecursive(files[i])) continue;
            return false;
        }
        return directory.delete();
    }

    public static boolean conflictsAny(File a, File b) {
        if (a.equals(b)) {
            return true;
        }
        HashSet<File> unique = new HashSet<File>();
        unique.add(a);
        for (File recursive : FileUtils.getFilesRecursive(a, null)) {
            unique.add(recursive);
        }
        if (unique.contains(b)) {
            return true;
        }
        for (File recursive : FileUtils.getFilesRecursive(b, null)) {
            if (!unique.contains(recursive)) continue;
            return true;
        }
        return false;
    }

    public static long getLengthRecursive(File f) {
        if (!f.isDirectory()) {
            return f.length();
        }
        long ret = 0L;
        for (File file : FileUtils.getFilesRecursive(f, null)) {
            ret += file.length();
        }
        return ret;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long copy(File src, long amount, File dst) {
        long amountToRead;
        int BUFFER_SIZE = 1024;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buf = new byte[1024];
            for (amountToRead = amount; amountToRead > 0L && (read = ((InputStream)in).read(buf, 0, (int)Math.min(1024L, amountToRead))) != -1; amountToRead -= (long)read) {
                ((OutputStream)out).write(buf, 0, read);
            }
        }
        catch (IOException e) {
            FileUtils.close(in);
            FileUtils.flush(out);
            FileUtils.close(out);
            catch (Throwable throwable) {
                FileUtils.close(in);
                FileUtils.flush(out);
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close(in);
        FileUtils.flush(out);
        FileUtils.close(out);
        return amount - amountToRead;
    }

    public static boolean copy(File src, File dst) {
        long length = src.length();
        return FileUtils.copy(src, (int)length, dst) == length;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        IOException iox = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(prefix, suffix, directory);
            }
            catch (IOException x) {
                iox = x;
                continue;
            }
        }
        throw iox;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        IOException iox = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(prefix, suffix);
            }
            catch (IOException x) {
                iox = x;
                continue;
            }
        }
        throw iox;
    }

    public static File getJarFromClasspath(String markerFile) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            classLoader = FileUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        return FileUtils.getJarFromClasspath(classLoader, markerFile);
    }

    public static File getJarFromClasspath(ClassLoader classLoader, String markerFile) {
        String url;
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        URL messagesURL = classLoader.getResource(markerFile);
        if (messagesURL != null && (url = CommonUtils.decode(messagesURL.toExternalForm())) != null && url.startsWith("jar:file:")) {
            url = url.substring("jar:file:".length(), url.length());
            url = url.substring(0, url.length() - markerFile.length() - "!/".length());
            return new File(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(File path) throws IOException {
        BufferedInputStream stream = null;
        Properties properties = new Properties();
        try {
            stream = new BufferedInputStream(new FileInputStream(path));
            properties.load(stream);
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(File path, Properties properties) throws IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(path));
            properties.store(stream, "");
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    public static void makeFolder(File path) throws IOException {
        if (path.isDirectory()) {
            return;
        }
        if (!path.mkdirs()) {
            throw new IOException("error from File.mkdirs()");
        }
    }

    public static File resolveSpecialPath(String path) throws IOException {
        if (path == null) {
            throw new IOException("no path");
        }
        int i = path.indexOf(">");
        if (i != -1) {
            String tag = path.substring(0, i);
            SystemUtils.SpecialLocations location = SystemUtils.SpecialLocations.parse(tag);
            if (location == null) {
                throw new IOException("unknown tag");
            }
            String special = SystemUtils.getSpecialPath(location);
            if (special == null) {
                throw new IOException("unable to get path");
            }
            path = path.substring(i + 1);
            return new File(special, path).getAbsoluteFile();
        }
        return FileUtils.getCanonicalFile(new File(path));
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        String[] contents;
        if (!sourceDirectory.isDirectory()) {
            throw new IOException("source directory not found");
        }
        if (destinationDirectory.exists()) {
            throw new IOException("destination directory already exists");
        }
        FileUtils.makeFolder(destinationDirectory);
        for (String name : contents = sourceDirectory.list()) {
            File source = new File(sourceDirectory, name);
            File destination = new File(destinationDirectory, name);
            if (source.isDirectory()) {
                FileUtils.copyDirectory(source, destination);
                continue;
            }
            if (FileUtils.copy(source, destination)) continue;
            throw new IOException("unable to copy file");
        }
    }
}

