/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    private GenericsUtils() {
    }

    public static <K, V> Map<K, V> scanForMap(Object o, Class<K> k, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForMap(Object, Class, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForMap(o, k, v, mode, null);
    }

    public static <K, V> Map<K, V> scanForMap(Object o, Class<K> k, Class<V> v, ScanMode mode, Class<? extends Map> createFromThis) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Map copy = null;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key != null && value != null && k.isAssignableFrom(key.getClass()) && v.isAssignableFrom(value.getClass())) continue;
                switch (mode) {
                    case EXCEPTION: {
                        StringBuilder errorReport = new StringBuilder();
                        if (key == null) {
                            errorReport.append("key is null ");
                        } else if (!k.isAssignableFrom(key.getClass())) {
                            errorReport.append("key class not assignable " + key.getClass() + " to " + k);
                        }
                        if (value == null) {
                            errorReport.append("value is null for key " + key);
                        } else if (!v.isAssignableFrom(value.getClass())) {
                            errorReport.append("value class not assignable " + value.getClass() + " to " + v);
                        }
                        throw new ClassCastException(errorReport.toString());
                    }
                    case REMOVE: {
                        i.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        if (copy == null) {
                            copy = GenericsUtils.newInstance(createFromThis);
                            copy.putAll(map);
                        }
                        copy.remove(key);
                    }
                }
            }
            if (copy != null) {
                return copy;
            }
            return map;
        }
        throw new ClassCastException();
    }

    public static <V> Collection<V> scanForCollection(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForCollection(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForCollection(o, v, mode, null);
    }

    public static <V> Collection<V> scanForCollection(Object o, Class<V> v, ScanMode mode, Class<? extends Collection> createFromThis) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Collection copy = null;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (value != null && v.isAssignableFrom(value.getClass())) continue;
                switch (mode) {
                    case EXCEPTION: {
                        throw new ClassCastException("wanted an instanceof: " + v + ", but was: " + (value == null ? "null" : value.getClass()));
                    }
                    case REMOVE: {
                        i.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        if (copy == null) {
                            copy = GenericsUtils.newInstance(createFromThis);
                            copy.addAll(c);
                        }
                        copy.remove(value);
                    }
                }
            }
            if (copy != null) {
                return copy;
            }
            return c;
        }
        throw new ClassCastException();
    }

    public static <V> Set<V> scanForSet(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForSet(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForSet(o, v, mode, null);
    }

    public static <V> Set<V> scanForSet(Object o, Class<V> v, ScanMode mode, Class<? extends Set> createFromThis) {
        if (o instanceof Set) {
            return (Set)GenericsUtils.scanForCollection(o, v, mode, createFromThis);
        }
        throw new ClassCastException();
    }

    public static <V> List<V> scanForList(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForList(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForList(o, v, mode, null);
    }

    public static <V> List<V> scanForList(Object o, Class<V> v, ScanMode mode, Class<? extends List> createFromThis) {
        if (o instanceof List) {
            return (List)GenericsUtils.scanForCollection(o, v, mode, createFromThis);
        }
        throw new ClassCastException();
    }

    private static <T> T newInstance(Class<? extends T> creator) {
        try {
            return creator.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScanMode {
        EXCEPTION,
        REMOVE,
        NEW_COPY_REMOVED;

    }
}

