/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Locale;

public class OSUtils {
    private static boolean _isWindows;
    private static boolean _isWindowsNT;
    private static boolean _isWindowsXP;
    private static boolean _isWindows95;
    private static boolean _isWindows98;
    private static boolean _isWindowsMe;
    private static boolean _isWindowsVista;
    private static boolean _supportsTray;
    private static boolean _isMacOSX;
    private static boolean _isMacOSX105;
    private static boolean _isLinux;
    private static boolean _isSolaris;
    private static boolean _isOS2;

    public static void setOperatingSystems() {
        _isWindows = false;
        _isWindowsVista = false;
        _isWindowsNT = false;
        _isWindowsXP = false;
        _isWindows95 = false;
        _isWindows98 = false;
        _isWindowsMe = false;
        _isSolaris = false;
        _isLinux = false;
        _isOS2 = false;
        _isMacOSX = false;
        _isMacOSX105 = false;
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean bl = _isWindows = os.indexOf("windows") != -1;
        if (os.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        }
        if (os.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        }
        if (os.indexOf("windows vista") != -1) {
            _isWindowsVista = true;
        }
        if (os.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (os.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (os.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        _isSolaris = os.indexOf("solaris") != -1;
        _isLinux = os.indexOf("linux") != -1;
        boolean bl2 = _isOS2 = os.indexOf("os/2") != -1;
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (os.startsWith("mac os") && os.endsWith("x")) {
            _isMacOSX = true;
            if (System.getProperty("os.version").startsWith("10.5")) {
                _isMacOSX105 = true;
            }
        }
    }

    public static String getOS() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsNT() {
        return _isWindowsNT;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindowsMe() {
        return _isWindowsMe;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isSocketChallengedWindows() {
        return OSUtils.isWindowsVista() || OSUtils.isWindowsXP();
    }

    public static boolean isNativeThemeWindows() {
        return OSUtils.isWindowsVista() || OSUtils.isWindowsXP();
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isMacOSX105() {
        return _isMacOSX105;
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isPOSIX() {
        return _isLinux || _isSolaris || _isMacOSX;
    }

    public static boolean isHighLoadOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isGoodWindows() {
        return OSUtils.isWindows() && OSUtils.isHighLoadOS();
    }

    public static boolean supportsTrash() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    public static int getMaxPathLength() {
        if (OSUtils.isWindows()) {
            return Short.MAX_VALUE;
        }
        if (OSUtils.isLinux()) {
            return 4095;
        }
        return 1023;
    }

    static {
        OSUtils.setOperatingSystems();
    }
}

