/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static volatile Collator COLLATOR = Collator.getInstance(Locale.getDefault());
    private static ThreadLocal<IdentityHashMap<Object, Object>> threadLocal;

    public static void setLocale(Locale locale) {
        Collator later = Collator.getInstance(locale);
        later.setDecomposition(2);
        later.setStrength(0);
        COLLATOR = later;
    }

    public static final boolean contains(String input, String pattern) {
        return StringUtils.contains(input, pattern, false);
    }

    public static final boolean contains(String input, String pattern, boolean ignoreCase) {
        int n = pattern.length();
        int last = 0;
        int i = 0;
        while (i < n) {
            int k;
            int j;
            int c = 32;
            for (j = i; j < n; ++j) {
                char c2 = pattern.charAt(j);
                if (c2 != ' ' && c2 != '+' && c2 != '*') continue;
                c = c2;
                break;
            }
            if ((k = StringUtils.subset(pattern, i, j, input, last, ignoreCase)) < 0) {
                return false;
            }
            if (c == 32 || c == 43) {
                last = 0;
            } else if (c == 42) {
                last = k + j - i;
            }
            i = j + 1;
        }
        return true;
    }

    public static boolean containsCharacters(String input, char[] chars) {
        char[] inputChars = input.toCharArray();
        Arrays.sort(inputChars);
        for (int i = 0; i < chars.length; ++i) {
            if (Arrays.binarySearch(inputChars, chars[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private static final int subset(String little, int littleStart, int littleStop, String big, int bigStart, boolean ignoreCase) {
        if (ignoreCase) {
            int n = big.length() - (littleStop - littleStart) + 1;
            block0: for (int i = bigStart; i < n; ++i) {
                int n2 = littleStop - littleStart;
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c1 = big.charAt(i + j);
                    if (c1 != (c2 = little.charAt(littleStart + j)) && c1 != StringUtils.toOtherCase(c2)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n = big.length() - (littleStop - littleStart) + 1;
        block2: for (int i = bigStart; i < n; ++i) {
            int n2 = littleStop - littleStart;
            for (int j = 0; j < n2; ++j) {
                char c2;
                char c1 = big.charAt(i + j);
                if (c1 != (c2 = little.charAt(littleStart + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char i = c;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        int SHIFT = 32;
        if (i < 'A') {
            return c;
        }
        if (i <= 'Z') {
            return (char)(i + 32);
        }
        if (i < 'a') {
            return c;
        }
        if (i <= 'z') {
            return (char)(i - 32);
        }
        return c;
    }

    public static String[] split(String s, char delimiter) {
        return StringUtils.split(s, Character.toString(delimiter));
    }

    public static String[] split(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] splitNoCoalesce(String s, char delimiter) {
        return StringUtils.splitNoCoalesce(s, Character.toString(delimiter));
    }

    public static String[] splitNoCoalesce(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        ArrayList<String> tokens = new ArrayList<String>();
        boolean gotDelimiter = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimiters.indexOf(token) >= 0) {
                if (gotDelimiter) {
                    tokens.add("");
                }
                gotDelimiter = true;
                continue;
            }
            tokens.add(token);
            gotDelimiter = false;
        }
        if (gotDelimiter && !tokens.isEmpty()) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static int compareFullPrimary(String s1, String s2) {
        return COLLATOR.compare(s1, s2);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int pl = prefix.length();
        if (s.length() < pl) {
            return false;
        }
        for (int i = 0; i < pl; ++i) {
            char pc;
            char sc = s.charAt(i);
            if (sc == (pc = prefix.charAt(i)) || (sc = Character.toUpperCase(sc)) == (pc = Character.toUpperCase(pc)) || (sc = Character.toLowerCase(sc)) == (pc = Character.toLowerCase(pc))) continue;
            return false;
        }
        return true;
    }

    public static String replace(String str, String old_str, String new_str) {
        int o = 0;
        StringBuilder buf = new StringBuilder();
        int i = str.indexOf(old_str);
        while (i > -1) {
            if (i > o) {
                buf.append(str.substring(o, i));
            }
            buf.append(new_str);
            o = i + old_str.length();
            i = str.indexOf(old_str, i + 1);
        }
        buf.append(str.substring(o, str.length()));
        return buf.toString();
    }

    public static String truncate(String string, int maxLen) {
        if (string.length() <= maxLen) {
            return string;
        }
        return string.substring(0, maxLen);
    }

    public static int indexOfIgnoreCase(String str, String substring) {
        return StringUtils.indexOfIgnoreCase(str, substring, Locale.getDefault());
    }

    public static int indexOfIgnoreCase(String str, String substring, Locale locale) {
        return str.toLowerCase(locale).indexOf(substring.toLowerCase(locale));
    }

    public static String getASCIIString(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "ISO-8859-1");
    }

    public static String getUTF8String(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "UTF-8");
    }

    private static String getEncodedString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public static String explode(String[] array, String delimeter) {
        StringBuilder sb = new StringBuilder();
        if (array.length > 0) {
            sb.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                sb.append(delimeter);
                sb.append(array[i]);
            }
        }
        return sb.toString();
    }

    public static String explode(Collection<String> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (!collection.isEmpty()) {
            Iterator<String> i = collection.iterator();
            sb.append(i.next());
            while (i.hasNext()) {
                sb.append(delimiter);
                sb.append(i.next());
            }
        }
        return sb.toString();
    }

    public static byte[] toUTF8Bytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported?", ex);
        }
    }

    public static String toStringFromUTF8Bytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported?", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object thiz, Object ... args) {
        boolean cleanUp = false;
        try {
            IdentityHashMap<Object, Object> handledObjects = threadLocal.get();
            if (handledObjects == null) {
                cleanUp = true;
                handledObjects = new IdentityHashMap();
                threadLocal.set(handledObjects);
            }
            if (handledObjects.containsKey(thiz)) {
                String string = "circular structure";
                return string;
            }
            handledObjects.put(thiz, thiz);
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            for (Field field : thiz.getClass().getDeclaredFields()) {
                try {
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    Object value = field.get(thiz);
                    field.setAccessible(accessible);
                    if (args.length != 0 && !Arrays.asList(args).contains(value)) continue;
                    fields.put(field.getName(), String.valueOf(value));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            String string = thiz.getClass().getSimpleName() + " " + ((Object)fields).toString();
            return string;
        }
        finally {
            if (cleanUp) {
                threadLocal.set(null);
            }
        }
    }

    static {
        COLLATOR.setDecomposition(2);
        COLLATOR.setStrength(0);
        threadLocal = new ThreadLocal();
    }
}

