/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static Log LOG = LogFactory.getLog(XMLUtils.class);

    private XMLUtils() {
    }

    public static Document getDocument(String xml) throws IOException {
        return XMLUtils.getDocument(xml, null, new LogErrorHandler(LOG));
    }

    public static Document getDocument(String xml, Log log) throws IOException {
        return XMLUtils.getDocument(xml, null, new LogErrorHandler(log));
    }

    public static Document getDocument(String xml, ErrorHandler errorHandler) throws IOException {
        return XMLUtils.getDocument(xml, null, errorHandler);
    }

    public static Document getDocument(String xml, EntityResolver resolver, ErrorHandler errorHandler) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            if (resolver != null) {
                builder.setEntityResolver(resolver);
            }
            builder.setErrorHandler(errorHandler);
            return builder.parse(is);
        }
        catch (IOException ioe) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to parse: " + xml, ioe);
            }
            throw ioe;
        }
        catch (SAXException sax) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to parse: " + xml, sax);
            }
            throw (IOException)new IOException().initCause(sax);
        }
        catch (ParserConfigurationException bad) {
            LOG.error("Unable to create parser", bad);
            throw (IOException)new IOException().initCause(bad);
        }
    }

    public static class LogErrorHandler
    implements ErrorHandler {
        private final Log log;

        public LogErrorHandler(Log log) {
            this.log = log;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.log.error("Parse error", exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.log.error("Parse fatal error", exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.log.error("Parse warning", exception);
        }
    }
}

