#include <qlistview.h>

/* FROM QT DOCS:
int QListViewItem::compare ( QListViewItem * i, int col, bool ascending ) const [virtual]
Compares this list view item to i using the column col in ascending order. Returns < 0 if this item is less than i, 0 if they are equal and > 0 if this item is greater than i. 
This function is used for sorting. 
The default implementation compares the item keys (key()) using QString::localeAwareCompare(). A reimplementation can use different values and a different comparison function. Here is a reimplementation that uses plain Unicode comparison: 
    int MyListViewItem::compare( QListViewItem *i, int col,
                                 bool ascending ) const
    {
        return key( col, ascending ).compare( i->key( col, ascending) );
    }

We don't recommend using ascending so your code can safely ignore it. 

*/

class IpListViewItem : public QListViewItem {
   
public:
   IpListViewItem ( QListView * parent );
   IpListViewItem ( QListViewItem * parent );
   IpListViewItem ( QListView * parent, QListViewItem * after );
   IpListViewItem ( QListViewItem * parent, QListViewItem * after );

   IpListViewItem ( QListView * parent, QString label );
   IpListViewItem ( QListViewItem * parent, QString label );
                    
   int compare( QListViewItem * i, int col, bool ) const;
   
   bool isOnline() const { return Online; };
   void setOnline( bool State ) { Online = State; };
private:
   bool Online;
protected:
   
};


