/*
Copyright (C) 2005  Oleg Grigoriev

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef IPRANGELISTER_H
#define IPRANGELISTER_H

#include <qcstring.h>
#include <qstringlist.h> 

//#define IPRANGELISTER_DEBUG

#define  SET_RANGE_ERROR   -1;

class ipRangeLister
{
public:
   ipRangeLister()
   {
      changed = TRUE;
      firstAddress="127.0.0.1";
      lastAddress="127.0.0.1";
   };
   
   int setRange(const QString range);  // yet only in "1.2.3.4-5.6.7.8" format
   QStringList getIpList();
   
   QCString getFirstAddress() const { return firstAddress; }; 
   QCString getLastAddress() const { return lastAddress; }; 
private:
   QStringList iplist;
   QCString firstAddress;
   unsigned long int fAddr;
   QCString lastAddress;
   unsigned long int lAddr;
   bool  changed;
   
   void makeList();
};


#endif // IPRANGELISTER_H

