/*
Copyright (C) 2005  Oleg Grigoriev

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "xmller.h"


int Xmller::saveToXmlFile( QListView *listView, const QString fileName )
{
   QFile f( fileName );
   if ( !f.open( IO_WriteOnly ) ) return -1;
   QTextStream t( &f );
   
   QDomDocument doc;
   QDomText dtxt;
   QDomElement range, ip, share;
   
   QDomElement root = doc.createElement( "IPRanges" );
   doc.appendChild( root );
   
   QListViewItemIterator it( listView );
   
   while ( it.current() ) 
   {
      if ( it.current()->depth() == 0 )
      {
         range = doc.createElement( "range" );
         range.setAttribute( "data", it.current()->text(0) );
         range.setAttribute( "comment", it.current()->text(1) );
         root.appendChild( range ); 
      }
      if ( it.current()->depth() == 1 )
      {
         ip = doc.createElement( "ip" );
         ip.setAttribute( "data", it.current()->text(0) );
         ip.setAttribute( "comment", it.current()->text(1) );
         range.appendChild( ip ); 
      }
      if ( it.current()->depth() == 2 )
      {
         share = doc.createElement( "share" );
         share.setAttribute( "data", it.current()->text(0) );
         ip.appendChild( share ); 
         
      }
      ++it;
   }
   
   doc.save( t, 3 );
   f.close();
   return 0;
}




int Xmller::loadFromXmlFile( QListView * listView, const QString fileName )
{
   QFile f( fileName );
   if ( !f.open( IO_ReadOnly ) ) { qWarning("Error opening " + fileName); return -1; }
   
   QString eStr;
   int eLine;
   int eColumn;
   
   
   QDomDocument doc;
   
   if ( !doc.setContent( &f, TRUE, &eStr, &eLine, &eColumn ) ) {
      f.close();
   qWarning("Error setting DOM content Line %d column %d : %s", eLine, eColumn, eStr.ascii() );
      return -2;
   }
   f.close();
   
   
   
   listView->clear();
   QListViewItem *rootItem;
   
   
   QDomElement docElem = doc.documentElement();
   
   if ( docElem.tagName() != "IPRanges" )
   {
      qWarning("The file is not IPRange file!");
      return -3;
   }
   
   QDomElement e;
   
   for( QDomNode n = docElem.firstChild(); !n.isNull(); n = n.nextSibling() )
      
   {
      if ( !n.isNull() && n.isElement() )
      {
         e = n.toElement();
         
         if ( e.tagName() == "range" )
         {
            rootItem = new QListViewItem( listView, e.attribute("data") );
            listView->insertItem( rootItem  );
            rootItem->setText(1, e.attribute("comment"));
            rootItem->setPixmap ( 0, QPixmap::fromMimeSource( "many-comp.png"  ) );
            rootItem->setOpen(TRUE);
            parseIP(e, rootItem);
            
         }
      }
   }
   
   
   return 0;
}


void Xmller::parseIP(const QDomElement &element, QListViewItem *item)
{
   IpListViewItem *newitem;
   QDomElement e;
   for( QDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling() )
      
   {
      if ( !n.isNull() && n.isElement() )
      {
         e = n.toElement();
         
         if ( e.tagName() == "ip" )
         {
            newitem = new IpListViewItem( item, e.attribute("data") );
            item->insertItem( newitem  );
            newitem->setText(1, e.attribute("comment"));
            newitem->setPixmap ( 0, QPixmap::fromMimeSource( "comp-off.png"  ) );
            newitem->setOpen(TRUE);
            parseShare(e, newitem);
            
         }
      }
   }
   
   
}


void Xmller::parseShare( const QDomElement &element, QListViewItem *item )
{
   QListViewItem *newitem;
   QDomElement e;
   for( QDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling() )
      
   {
      if ( !n.isNull() && n.isElement() )
      {
         e = n.toElement();
         
         if ( e.tagName() == "share" )
         {
            newitem = new QListViewItem( item, e.attribute("data") );
            item->insertItem( newitem  );
            if ( e.attribute("data") == "ftp://" ) newitem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-ftp.png"  ) );
            else   
               if ( e.attribute("data") == "http://" ) newitem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-http.png"  ) );  
            else   
               newitem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-smb.png"  ) );
            
         }
      }
   }
   
   
}
