/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.Challenge;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.address.URI;

public abstract class AuthenticationHeader
extends ParametersHeader {
    public static String DOMAIN = "domain";
    public static String REALM = "realm";
    public static String OPAQUE = "opaque";
    public static String ALGORITHM = "algorithm";
    public static String QOP = "qop";
    public static String STALE = "stale";
    public static String SIGNATURE = "signature";
    public static String RESPONSE = "response";
    public static String SIGNED_BY = "signed-by";
    public static String NC = "nc";
    public static String URI = "uri";
    public static String USERNAME = "username";
    public static String CNONCE = "cnonce";
    public static String NONCE = "nonce";
    protected String scheme;

    public AuthenticationHeader(String name) {
        super(name);
        this.parameters.setSeparator(",");
        this.scheme = "Digest";
    }

    public AuthenticationHeader() {
        this.parameters.setSeparator(",");
    }

    public void setParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        if (nv == null) {
            nv = new NameValue(name, value);
            if (name.equalsIgnoreCase("qop") || name.equalsIgnoreCase("realm") || name.equalsIgnoreCase("cnonce") || name.equalsIgnoreCase("nonce") || name.equalsIgnoreCase("username") || name.equalsIgnoreCase("domain") || name.equalsIgnoreCase("opaque") || name.equalsIgnoreCase("nextnonce") || name.equalsIgnoreCase("uri") || name.equalsIgnoreCase("response")) {
                nv.setQuotedValue();
                if (value == null) {
                    throw new NullPointerException("null value");
                }
                if (value.startsWith("\"")) {
                    throw new ParseException(value + " : Unexpected DOUBLE_QUOTE", 0);
                }
            }
            super.setParameter(nv);
        } else {
            nv.setValue(value);
        }
    }

    public void setChallenge(Challenge challenge) {
        this.scheme = challenge.scheme;
        this.parameters = challenge.authParams;
    }

    public String encodeBody() {
        return this.scheme + " " + this.parameters.encode();
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRealm(String realm) throws ParseException {
        if (realm == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setRealm(), The realm parameter is null");
        }
        this.setParameter("realm", realm);
    }

    public String getRealm() {
        return this.getParameter("realm");
    }

    public void setNonce(String nonce) throws ParseException {
        if (nonce == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setNonce(), The nonce parameter is null");
        }
        this.setParameter(NONCE, nonce);
    }

    public String getNonce() {
        return this.getParameter("nonce");
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null URI");
        }
        NameValue nv = new NameValue("uri", uri);
        nv.setQuotedValue();
        this.parameters.set(nv);
    }

    public URI getURI() {
        return this.getParameterAsURI("uri");
    }

    public void setAlgorithm(String algorithm) throws ParseException {
        if (algorithm == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter("algorithm", algorithm);
    }

    public String getAlgorithm() {
        return this.getParameter("algorithm");
    }

    public void setQop(String qop) throws ParseException {
        if (qop == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter("qop", qop);
    }

    public String getQop() {
        return this.getParameter("qop");
    }

    public void setOpaque(String opaque) throws ParseException {
        if (opaque == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter("opaque", opaque);
    }

    public String getOpaque() {
        return this.getParameter("opaque");
    }

    public void setDomain(String domain) throws ParseException {
        if (domain == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter("domain", domain);
    }

    public String getDomain() {
        return this.getParameter("domain");
    }

    public void setStale(boolean stale) {
        this.setParameter(new NameValue("stale", new Boolean(stale)));
    }

    public boolean isStale() {
        return this.getParameterAsBoolean("stale");
    }

    public void setCNonce(String cnonce) throws ParseException {
        this.setParameter("cnonce", cnonce);
    }

    public String getCNonce() {
        return this.getParameter("cnonce");
    }

    public int getNonceCount() {
        return this.getParameterAsHexInt("nc");
    }

    public void setNonceCount(int param) throws ParseException {
        if (param < 0) {
            throw new ParseException("bad value", 0);
        }
        String nc = Integer.toHexString(param);
        String base = "00000000";
        nc = base.substring(0, 8 - nc.length()) + nc;
        this.setParameter("nc", nc);
    }

    public String getResponse() {
        return (String)this.getParameterValue("response");
    }

    public void setResponse(String response) throws ParseException {
        if (response == null) {
            throw new NullPointerException("Null parameter");
        }
        this.setParameter(RESPONSE, response);
    }

    public String getUsername() {
        return this.getParameter("username");
    }

    public void setUsername(String username) throws ParseException {
        this.setParameter("username", username);
    }
}

