/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.LexerCore;
import java.util.Hashtable;

public class Lexer
extends LexerCore {
    public static String getHeaderName(String line) {
        if (line == null) {
            return null;
        }
        String headerName = null;
        try {
            int begin = line.indexOf(":");
            headerName = null;
            if (begin >= 1) {
                headerName = line.substring(0, begin).trim();
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerName;
    }

    public Lexer(String lexerName, String buffer) {
        super(lexerName, buffer);
        this.selectLexer(lexerName);
    }

    public static String getHeaderValue(String line) {
        if (line == null) {
            return null;
        }
        String headerValue = null;
        try {
            int begin = line.indexOf(":");
            headerValue = line.substring(begin + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerValue;
    }

    public void selectLexer(String lexerName) {
        this.currentLexer = (Hashtable)lexerTables.get(lexerName);
        this.currentLexerName = lexerName;
        if (this.currentLexer == null) {
            this.addLexer(lexerName);
            if (lexerName.equals("method_keywordLexer")) {
                this.addKeyword("REGISTER".toUpperCase(), 2052);
                this.addKeyword("ACK".toUpperCase(), 2054);
                this.addKeyword("OPTIONS".toUpperCase(), 2056);
                this.addKeyword("BYE".toUpperCase(), 2055);
                this.addKeyword("INVITE".toUpperCase(), 2053);
                this.addKeyword("sip".toUpperCase(), 2051);
                this.addKeyword("SUBSCRIBE".toUpperCase(), 2101);
                this.addKeyword("NOTIFY".toUpperCase(), 2102);
            } else if (lexerName.equals("command_keywordLexer")) {
                this.addKeyword("Error-Info".toUpperCase(), 2058);
                this.addKeyword("Allow-Events".toUpperCase(), 2113);
                this.addKeyword("Authentication-Info".toUpperCase(), 2112);
                this.addKeyword("Event".toUpperCase(), 2111);
                this.addKeyword("Min-Expires".toUpperCase(), 2110);
                this.addKeyword("RSeq".toUpperCase(), 2108);
                this.addKeyword("RAck".toUpperCase(), 2109);
                this.addKeyword("Reason".toUpperCase(), 2107);
                this.addKeyword("Reply-To".toUpperCase(), 2106);
                this.addKeyword("Subscription-State".toUpperCase(), 2104);
                this.addKeyword("Timestamp".toUpperCase(), 2103);
                this.addKeyword("In-Reply-To".toUpperCase(), 2059);
                this.addKeyword("MIME-Version".toUpperCase(), 2060);
                this.addKeyword("Alert-Info".toUpperCase(), 2061);
                this.addKeyword("From".toUpperCase(), 2062);
                this.addKeyword("To".toUpperCase(), 2063);
                this.addKeyword("Refer-To".toUpperCase(), 2114);
                this.addKeyword("Via".toUpperCase(), 2064);
                this.addKeyword("User-Agent".toUpperCase(), 2065);
                this.addKeyword("Server".toUpperCase(), 2066);
                this.addKeyword("Accept-Encoding".toUpperCase(), 2067);
                this.addKeyword("Accept".toUpperCase(), 2068);
                this.addKeyword("Allow".toUpperCase(), 2069);
                this.addKeyword("Route".toUpperCase(), 2070);
                this.addKeyword("Authorization".toUpperCase(), 2071);
                this.addKeyword("Proxy-Authorization".toUpperCase(), 2072);
                this.addKeyword("Retry-After".toUpperCase(), 2073);
                this.addKeyword("Proxy-Require".toUpperCase(), 2074);
                this.addKeyword("Content-Language".toUpperCase(), 2075);
                this.addKeyword("Unsupported".toUpperCase(), 2076);
                this.addKeyword("Supported".toUpperCase(), 2068);
                this.addKeyword("Warning".toUpperCase(), 2078);
                this.addKeyword("Max-Forwards".toUpperCase(), 2079);
                this.addKeyword("Date".toUpperCase(), 2080);
                this.addKeyword("Priority".toUpperCase(), 2081);
                this.addKeyword("Proxy-Authenticate".toUpperCase(), 2082);
                this.addKeyword("Content-Encoding".toUpperCase(), 2083);
                this.addKeyword("Content-Length".toUpperCase(), 2084);
                this.addKeyword("Subject".toUpperCase(), 2085);
                this.addKeyword("Content-Type".toUpperCase(), 2086);
                this.addKeyword("Contact".toUpperCase(), 2087);
                this.addKeyword("Call-ID".toUpperCase(), 2088);
                this.addKeyword("Require".toUpperCase(), 2089);
                this.addKeyword("Expires".toUpperCase(), 2090);
                this.addKeyword("Record-Route".toUpperCase(), 2092);
                this.addKeyword("Organization".toUpperCase(), 2093);
                this.addKeyword("CSeq".toUpperCase(), 2094);
                this.addKeyword("Accept-Language".toUpperCase(), 2095);
                this.addKeyword("WWW-Authenticate".toUpperCase(), 2096);
                this.addKeyword("Call-Info".toUpperCase(), 2099);
                this.addKeyword("Content-Disposition".toUpperCase(), 2100);
                this.addKeyword("K".toUpperCase(), 2068);
                this.addKeyword("C".toUpperCase(), 2086);
                this.addKeyword("E".toUpperCase(), 2083);
                this.addKeyword("F".toUpperCase(), 2062);
                this.addKeyword("I".toUpperCase(), 2088);
                this.addKeyword("M".toUpperCase(), 2087);
                this.addKeyword("L".toUpperCase(), 2084);
                this.addKeyword("S".toUpperCase(), 2085);
                this.addKeyword("T".toUpperCase(), 2063);
                this.addKeyword("V".toUpperCase(), 2064);
                this.addKeyword("R".toUpperCase(), 2114);
            } else if (lexerName.equals("status_lineLexer")) {
                this.addKeyword("sip".toUpperCase(), 2051);
            } else if (lexerName.equals("request_lineLexer")) {
                this.addKeyword("sip".toUpperCase(), 2051);
            } else if (lexerName.equals("sip_urlLexer")) {
                this.addKeyword("tel".toUpperCase(), 2105);
                this.addKeyword("sip".toUpperCase(), 2051);
            }
        }
    }
}

