/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;

public final class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private OutputStream myClientOutputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private SIPMessageStack stack;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    private String peerProtocol;
    protected int useCount;
    private TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(Socket sock, SIPMessageStack sipStack, TCPMessageProcessor msgProcessor) throws IOException {
        if (LogWriter.needsLogging) {
            sipStack.logWriter.logMessage("creating new TCPMessageChannel ");
            sipStack.logWriter.logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = sipStack.getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TCPMessageChannelThread");
        this.stack = sipStack;
        this.tcpMessageProcessor = msgProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddr, int port, SIPMessageStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        if (LogWriter.needsLogging) {
            sipStack.logWriter.logMessage("creating new TCPMessageChannel ");
            sipStack.logWriter.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.stack = sipStack;
        this.tcpMessageProcessor = messageProcessor;
        this.myAddress = sipStack.getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = messageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Closing message Channel " + this);
                }
            }
            catch (IOException ex) {
                if (!LogWriter.needsLogging) break block4;
                this.stack.logWriter.logMessage("Error closing socket " + ex);
            }
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean retry) throws IOException {
        Socket sock = this.stack.ioHandler.sendBytes(this.peerAddress, this.peerPort, this.peerProtocol, msg, retry);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        if (this.stack.serverLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket sock = this.stack.ioHandler.sendBytes(receiverAddress, receiverPort, "TCP", message, retry);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread mythread = new Thread(this);
            mythread.setDaemon(true);
            mythread.setName("TCPMessageChannelThread");
            mythread.start();
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            this.stack.logBadMessage(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
            String badmsg = sipMessage.encode();
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("bad message " + badmsg);
                this.stack.logWriter.logMessage(">>> Dropped Bad Msg");
            }
            this.stack.logBadMessage(badmsg);
            return;
        }
        ViaList viaList = sipMessage.getViaHeaders();
        if (sipMessage instanceof SIPRequest) {
            Via v = (Via)viaList.first();
            this.peerPort = v.hasPort() ? v.getPort() : 5060;
            this.peerProtocol = v.getTransport();
            try {
                this.peerAddress = this.mySock.getInetAddress();
                if (!v.getSentBy().getInetAddress().equals(this.peerAddress)) {
                    v.setParameter("received", this.peerAddress.getHostAddress());
                }
            }
            catch (UnknownHostException ex) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message -- could not resolve Via Address");
                }
                return;
            }
            catch (ParseException ex) {
                InternalErrorHandler.handleException(ex);
            }
            if (!this.isCached) {
                ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                this.isCached = true;
                String key = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                this.stack.ioHandler.putSocket(key, this.mySock);
            }
        }
        long receptionTime = System.currentTimeMillis();
        if (sipMessage instanceof SIPRequest) {
            SIPRequest sipRequest = (SIPRequest)sipMessage;
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("----Processing Message---");
            }
            if (this.stack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.stack.getMaxMessageSize()) {
                SIPResponse sipResponse = sipRequest.createResponse(513);
                byte[] resp = sipResponse.encodeAsBytes();
                this.sendMessage(resp, false);
                throw new Exception("Message size exceeded");
            }
            ServerRequestInterface sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this);
            sipServerRequest.processRequest(sipRequest, this);
            if (this.stack.serverLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                if (sipServerRequest.getProcessingInfo() == null) {
                    this.stack.serverLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), false, receptionTime);
                } else {
                    this.stack.serverLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), sipServerRequest.getProcessingInfo(), false, receptionTime);
                }
            }
        } else {
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            if (this.stack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.stack.getMaxMessageSize()) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
            sipServerResponse.processResponse(sipResponse, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.stack.readTimeout, ((SIPTransactionStack)this.stack).timer);
        this.myParser = new PipelinedMsgParser(this, hispipe, this.stack.getMaxMessageSize());
        this.myParser.processInput();
        int bufferSize = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int nbytes;
                byte[] msg;
                try {
                    msg = new byte[bufferSize];
                    nbytes = this.myClientInputStream.read(msg, 0, bufferSize);
                    if (nbytes == -1) {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.stack.maxConnections != -1) {
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            hispipe.close();
                            this.mySock.close();
                        }
                        catch (IOException ioex) {
                        }
                        Object var10_13 = null;
                        this.isRunning = false;
                        this.tcpMessageProcessor.remove(this);
                        --this.tcpMessageProcessor.useCount;
                        return;
                    }
                }
                catch (IOException ex) {
                    try {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (LogWriter.needsLogging) {
                            this.stack.logWriter.logMessage("IOException  closing sock " + ex);
                        }
                        try {
                            if (this.stack.maxConnections != -1) {
                                TCPMessageProcessor e = this.tcpMessageProcessor;
                                synchronized (e) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            this.mySock.close();
                            hispipe.close();
                        }
                        catch (IOException ioex) {}
                    }
                    catch (Exception ex1) {
                    }
                    Object var10_14 = null;
                    this.isRunning = false;
                    this.tcpMessageProcessor.remove(this);
                    --this.tcpMessageProcessor.useCount;
                    return;
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                    continue;
                }
                {
                    hispipe.write(msg, 0, nbytes);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
            throw throwable;
        }
    }

    protected void uncache() {
        this.tcpMessageProcessor.remove(this);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public boolean isSecure() {
        return false;
    }
}

