/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Message;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.MessageEventHandler;
import net.java.stun4j.stack.NetAccessManager;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunClientTransaction;
import net.java.stun4j.stack.StunStack;
import net.java.stun4j.stack.TransactionID;

public class StunProvider
implements MessageEventHandler {
    private Hashtable clientTransactions = new Hashtable();
    private Vector serverTransactions = new Vector();
    private StunStack stunStack = null;
    private RequestListener requestListener = null;

    StunProvider(StunStack stunStack) {
        this.stunStack = stunStack;
    }

    public void sendRequest(Request request, StunAddress sendTo, NetAccessPointDescriptor sendThrough, ResponseCollector collector) throws StunException {
        this.stunStack.checkStarted();
        StunClientTransaction clientTransaction = new StunClientTransaction(this, request, sendTo, sendThrough, collector);
        this.clientTransactions.put(clientTransaction.getTransactionID(), clientTransaction);
        clientTransaction.sendRequest();
    }

    public void sendResponse(byte[] transactionID, Response response, NetAccessPointDescriptor sendThrough, StunAddress sendTo) throws StunException {
        this.stunStack.checkStarted();
        TransactionID tid = TransactionID.createTransactionID(transactionID);
        if (!this.serverTransactions.remove(tid)) {
            throw new StunException(3, "The trensaction specified in the response object does not exist.");
        }
        response.setTransactionID(transactionID);
        this.getNetAccessManager().sendMessage(response, sendThrough, sendTo);
    }

    public void setRequestListener(RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    NetAccessManager getNetAccessManager() {
        return this.stunStack.getNetAccessManager();
    }

    void removeClientTransaction(StunClientTransaction tran) {
        this.clientTransactions.remove(tran.getTransactionID());
    }

    public void handleMessageEvent(StunMessageEvent event) {
        TransactionID tid;
        StunClientTransaction tran;
        Message msg = event.getMessage();
        if (msg instanceof Request) {
            TransactionID serverTid = TransactionID.createTransactionID(msg.getTransactionID());
            this.serverTransactions.add(serverTid);
            if (this.requestListener != null) {
                this.requestListener.requestReceived(event);
            }
        } else if (msg instanceof Response && (tran = (StunClientTransaction)this.clientTransactions.remove(tid = TransactionID.createTransactionID(msg.getTransactionID()))) != null) {
            tran.handleResponse(event);
        }
    }

    void shutDown() {
        this.requestListener = null;
        Enumeration tids = this.clientTransactions.keys();
        while (tids.hasMoreElements()) {
            TransactionID item = (TransactionID)tids.nextElement();
            StunClientTransaction tran = (StunClientTransaction)this.clientTransactions.remove(item);
            if (tran == null) continue;
            tran.cancel();
        }
    }
}

