/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.UPnPStatus;
import com.fujitsu.fla.upnp.test.CtrlPoint;
import com.fujitsu.fla.upnp.test.StateVariableTable;
import com.fujitsu.fla.upnp.test.TableComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StateVariablePane
extends JPanel
implements ActionListener {
    private CtrlPoint ctrlPoint;
    private StateVariable stateVar;
    private StateVariableTable stateVarTable;
    private JButton queryButton;

    public StateVariablePane(CtrlPoint ctrlPoint, StateVariable var) {
        this.setLayout(new BorderLayout());
        this.ctrlPoint = ctrlPoint;
        this.stateVar = var;
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        this.stateVarTable = new StateVariableTable(var);
        tablePane.add((Component)new TableComp(this.stateVarTable), "Center");
        this.add((Component)tablePane, "Center");
        JPanel buttonPane = new JPanel();
        this.queryButton = new JButton("Query");
        buttonPane.add(this.queryButton);
        this.queryButton.addActionListener(this);
        this.add((Component)buttonPane, "South");
    }

    private Frame getFrame() {
        return (Frame)this.getRootPane().getParent();
    }

    public StateVariable getStateVariable() {
        return this.stateVar;
    }

    public StateVariableTable getTable() {
        return this.stateVarTable;
    }

    public JButton getButton() {
        return this.queryButton;
    }

    public void actionPerformed(ActionEvent e) {
        String msg;
        if (e.getSource() != this.queryButton) {
            return;
        }
        String title = this.stateVar.getName();
        boolean queryRes = this.stateVar.postQuerylAction();
        if (queryRes) {
            msg = String.valueOf(this.stateVar.getName()) + " = " + this.stateVar.getValue();
        } else {
            UPnPStatus err = this.stateVar.getQueryStatus();
            msg = String.valueOf(err.getDescription()) + " (" + Integer.toString(err.getCode()) + ")";
        }
        this.ctrlPoint.printConsole(String.valueOf(title) + " : " + msg);
        JOptionPane.showMessageDialog(this, msg, title, -1);
    }
}

