/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private IMA4State ima4state;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ima4")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "IMA4 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 1, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4state = new IMA4State();
    }

    public void close() {
        this.ima4state = null;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = this.outputFormat.getChannels();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, byArray.length * 4);
        int n3 = this.decodeJavaIMA4(byArray, byArray2, buffer.getLength(), byArray2.length, n2);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        return 0;
    }

    int decodeJavaIMA4(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                return this.decodeIMA4mono(byArray, byArray2, n2, n3, 32);
            }
            case 2: {
                return this.decodeIMA4stereo(byArray, byArray2, n2, n3, 32);
            }
        }
        throw new RuntimeException("IMA4: Can only handle 1 or 2 channels\n");
    }

    private int decodeIMA4mono(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        n2 = n2 / (n4 + 2) * (n4 + 2);
        while (n5 < n2) {
            int n7;
            int n8 = byArray[n5++] << 8;
            if ((n7 = (n8 |= byArray[n5++] & 0xFF) & 0x7F) > 88) {
                n7 = 88;
            }
            this.ima4state.valprev = n8 & 0xFFFFFF80;
            this.ima4state.index = n7;
            IMA4.decode(byArray, n5, byArray2, n6, n4 << 1, this.ima4state, 0);
            n5 += n4;
            n6 += n4 << 2;
        }
        return n6;
    }

    private int decodeIMA4stereo(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        n2 = n2 / 2 / (n4 + 2) * (n4 + 2) * 2;
        while (n5 < n2) {
            int n7;
            int n8 = byArray[n5++] << 8;
            if ((n7 = (n8 |= byArray[n5++] & 0xFF) & 0x7F) > 88) {
                n7 = 88;
            }
            this.ima4state.valprev = n8 & 0xFFFFFF80;
            this.ima4state.index = n7;
            IMA4.decode(byArray, n5, byArray2, n6, n4 << 1, this.ima4state, 2);
            n5 += n4;
            int n9 = byArray[n5++] << 8;
            int n10 = (n9 |= byArray[n5++] & 0xFF) & 0x7F;
            if (n10 > 88) {
                n10 = 88;
            }
            this.ima4state.valprev = n9 & 0xFFFFFF80;
            this.ima4state.index = n10;
            IMA4.decode(byArray, n5, byArray2, n6 + 2, n4 << 1, this.ima4state, 2);
            n5 += n4;
            n6 += n4 << 3;
        }
        return n6;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

