/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends BufferedEncoder {
    private IMA4State ima4stateL;
    private IMA4State ima4stateR;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ima4")};
        this.PLUGIN_NAME = "IMA4 Encoder";
        this.historySize = 256;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ima4", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), -1, -1, 272 * audioFormat.getChannels(), -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4stateL = new IMA4State();
        this.ima4stateR = new IMA4State();
    }

    public void close() {
        this.ima4stateL = null;
        this.ima4stateR = null;
    }

    public void codecReset() {
        this.ima4stateL.index = 0;
        this.ima4stateL.valprev = 0;
        this.ima4stateR.index = 0;
        this.ima4stateR.valprev = 0;
    }

    protected int calculateOutputSize(int n2) {
        return this.calculateFramesNumber(n2) * 34 * 2;
    }

    protected int calculateFramesNumber(int n2) {
        return n2 / 128;
    }

    protected boolean codecProcess(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n5 = 0;
        int n6 = 0;
        int n7 = this.inputFormat.getChannels();
        boolean bl = n7 == 2;
        int n8 = bl ? 2 : 0;
        int n9 = n4 / (n7 * 128);
        nArray4[0] = n3;
        int n10 = 0;
        while (n10 < n9) {
            if (this.ima4stateL.index > 88) {
                this.ima4stateL.index = 88;
            } else if (this.ima4stateL.index < 0) {
                this.ima4stateL.index = 0;
            }
            this.ima4stateL.valprev &= 0xFFFFFF80;
            int n11 = this.ima4stateL.valprev | this.ima4stateL.index;
            byArray2[n3 + n6++] = (byte)(n11 >> 8);
            byArray2[n3 + n6++] = (byte)n11;
            IMA4.encode(byArray, n2 + n5, byArray2, n3 + n6, 64, this.ima4stateL, n8);
            n6 += 32;
            if (bl) {
                if (this.ima4stateR.index > 88) {
                    this.ima4stateR.index = 88;
                } else if (this.ima4stateR.index < 0) {
                    this.ima4stateR.index = 0;
                }
                this.ima4stateR.valprev &= 0xFFFFFF80;
                int n12 = this.ima4stateR.valprev | this.ima4stateR.index;
                byArray2[n3 + n6++] = (byte)(n12 >> 8);
                byArray2[n3 + n6++] = (byte)n12;
                IMA4.encode(byArray, n2 + n5 + 2, byArray2, n3 + n6, 64, this.ima4stateR, n8);
                n6 += 32;
                n5 += 256;
            } else {
                n5 += 128;
            }
            nArray4[n10 + 1] = n6 + n3;
            this.regionsTypes[n10] = 0;
            ++n10;
        }
        nArray[0] = n5;
        nArray2[0] = n6;
        nArray3[0] = n9;
        return true;
    }
}

