/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class MpegVideo
extends BasicCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1998, 1999.";
    static final int VERSION_BUF_LEN = 70;
    static final int MPEG_INTERNAL_BUF_SIZE = 65536;
    static final int IN_STREAM_BUF_LEN = 102400;
    static final int OUT_FRAME_BUF_LEN = 270000;
    static final int NO_PICTURE = 0;
    static final int I_PICTURE = 1;
    static final int P_PICTURE = 2;
    static final int B_PICTURE = 3;
    static final int D_PICTURE = 4;
    static final int MPEG_NOERROR = 0;
    static final int MPEG_ERROR = -1;
    static final int MPEG_PARAM_ERROR = -2;
    static final int MPEG_BUF_ERROR = -3;
    static final int MPEG_ALLOC_ERROR = -4;
    static final int MPEG_EOS = -5;
    private Object methodsSync = new Object();
    protected VideoFormat[] supportedInFormats = null;
    protected VideoFormat[] supportedOutFormats = null;
    protected VideoFormat inputFormat = null;
    protected VideoFormat outputFormat = null;
    private boolean corruptedFlag = false;
    private boolean firstTimeFlag = true;
    private boolean inputEOMFlag = false;
    private boolean processEOMFlag = false;
    private boolean resetFlag = true;
    private long accumulatedTimeNs = 0L;
    private double deltaPictureTimeNS = 0.0;
    private double dAccumulatedTime = 0.0;
    private long[] pdata = new long[1];
    private byte[] versionBuf = new byte[70];
    private int[] inBytesReq = new int[1];
    private int frameNumber = -1;
    private byte[] inBufByte = new byte[102400];
    private byte[] outBufByte = null;
    private int inDataOffset = 0;
    private int outBufOffset = 0;
    private int numDataBytes = 0;
    private int numFramesBehind = 0;
    private int dropCount = 0;
    private int[] imgWidth = new int[1];
    private int[] imgHeight = new int[1];
    private int[] imgType = new int[1];
    private int[] inBytesRead = new int[1];
    private int[] outBufWrote = new int[1];
    private static boolean available;
    private Control[] controls = null;
    private DC dc = null;

    private native int videoInitialize(long[] var1, byte[] var2, int var3, int var4);

    private native int initImageParam(long var1, byte[] var3, int var4, int var5, int[] var6, int[] var7);

    private native int videoDecode(long var1, byte[] var3, int var4, int var5, int var6, Object var7, long var8, int var10, int var11, int[] var12, int[] var13, int[] var14, int[] var15, int[] var16, int[] var17);

    private native int videoTerminate(long var1);

    private native int videoReset(long var1);

    private native int videoSeek(long var1);

    public MpegVideo() {
        if (available) {
            this.supportedInFormats = new VideoFormat[2];
            this.supportedInFormats[0] = new VideoFormat("mpeg");
            this.supportedInFormats[1] = new VideoFormat("MPGI");
            this.supportedOutFormats = new VideoFormat[1];
            this.supportedOutFormats[0] = new YUVFormat(2);
        } else {
            this.supportedInFormats = new VideoFormat[0];
        }
    }

    public String getName() {
        return "MPEG-1 Video Decoder";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutFormats;
        }
        if (format instanceof VideoFormat && BasicPlugIn.matches(format, this.supportedInFormats) != null) {
            VideoFormat videoFormat = (VideoFormat)format;
            Dimension dimension = videoFormat.getSize();
            if (dimension == null || dimension.width == 0 || dimension.height == 0) {
                dimension = new Dimension(320, 240);
            }
            int n2 = dimension.width * dimension.height;
            YUVFormat yUVFormat = new YUVFormat(dimension, n2 + (n2 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, dimension.width, dimension.width >> 1, 0, n2, n2 + (n2 >> 2));
            Format[] formatArray = new Format[]{yUVFormat};
            return formatArray;
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || BasicPlugIn.matches(format, this.supportedInFormats) == null) {
            return null;
        }
        this.inputFormat = (VideoFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (format != null && format instanceof YUVFormat && ((YUVFormat)format).getYuvType() == 2) {
            this.outputFormat = (VideoFormat)format;
            return format;
        }
        return null;
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("Can't find shared library jmmpegv");
        }
        Object object = this.methodsSync;
        synchronized (object) {
            if (this.videoInitialize(this.pdata, this.versionBuf, 0, 70) != 0) {
                throw new ResourceUnavailableException("MPEG video decoder initialization failed");
            }
            available = false;
            this.inBytesReq[0] = 65536;
        }
        float f2 = this.inputFormat.getFrameRate();
        this.deltaPictureTimeNS = f2 > 0.0f ? 1.0E9 / (double)f2 : 0.0;
    }

    public void reset() {
        Object object = this.methodsSync;
        synchronized (object) {
            this.corruptedFlag = false;
            this.inputEOMFlag = false;
            this.processEOMFlag = false;
            this.inBytesReq[0] = 65536;
            this.frameNumber = -1;
            this.inDataOffset = 0;
            this.outBufOffset = 0;
            this.numDataBytes = 0;
            this.numFramesBehind = 0;
            this.dropCount = 0;
            int n2 = this.videoSeek(this.pdata[0]);
            if (n2 != 0) {
                this.corruptedFlag = true;
            }
            this.resetFlag = true;
        }
    }

    public void close() {
        Object object = this.methodsSync;
        synchronized (object) {
            this.videoTerminate(this.pdata[0]);
            this.corruptedFlag = false;
            this.firstTimeFlag = true;
            this.inputEOMFlag = false;
            this.processEOMFlag = false;
            this.pdata = new long[1];
            this.inBytesReq[0] = 65536;
            this.frameNumber = -1;
            this.inDataOffset = 0;
            this.outBufOffset = 0;
            this.numDataBytes = 0;
            this.numFramesBehind = 0;
            this.dropCount = 0;
            available = true;
        }
    }

    private boolean doInit(Buffer buffer, Buffer buffer2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Object object = buffer.getData();
        int n2 = buffer.getLength();
        int n3 = buffer.getOffset();
        if (n2 < 512) {
            return false;
        }
        int n4 = this.initImageParam(this.pdata[0], (byte[])object, n3, n2, nArray, nArray2);
        if (n4 != 0) {
            return false;
        }
        int n5 = (int)((double)(nArray[0] * nArray2[0]) * 1.5);
        this.outBufByte = new byte[n5];
        Dimension dimension = new Dimension(nArray[0], nArray2[0]);
        int n6 = dimension.width * dimension.height;
        this.outputFormat = new YUVFormat(dimension, n6 + (n6 >> 1), Format.byteArray, this.inputFormat.getFrameRate(), 2, dimension.width, dimension.width >> 1, 0, n6, n6 + (n6 >> 2));
        buffer2.setFormat(this.outputFormat);
        return true;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        this.imgWidth[0] = 0;
        this.imgHeight[0] = 0;
        this.imgType[0] = 0;
        this.inBytesRead[0] = 0;
        this.outBufWrote[0] = 0;
        int n2 = 0;
        Object object = this.methodsSync;
        synchronized (object) {
            int n3;
            Object object2;
            if (!this.checkInputBuffer(buffer)) {
                int n4 = 1;
                return n4;
            }
            if (this.processEOMFlag) {
                this.propagateEOM(buffer2);
                int n5 = 0;
                return n5;
            }
            if (this.corruptedFlag) {
                int n6 = 1;
                return n6;
            }
            if (this.isEOM(buffer)) {
                this.inputEOMFlag = true;
            }
            if (this.firstTimeFlag) {
                if (!this.doInit(buffer, buffer2)) {
                    int n7 = 1;
                    return n7;
                }
                this.firstTimeFlag = false;
            }
            if (this.numDataBytes < this.inBytesReq[0] && !this.inputEOMFlag) {
                object2 = (byte[])buffer.getData();
                int n8 = buffer.getLength();
                int n9 = buffer.getOffset();
                n3 = 102400 - this.numDataBytes - 1;
                if (this.numDataBytes > 0 && this.inDataOffset > 0) {
                    System.arraycopy(this.inBufByte, this.inDataOffset, this.inBufByte, 0, this.numDataBytes);
                }
                this.inDataOffset = 0;
                if (n3 > n8) {
                    n3 = n8;
                }
                if (n3 > 0) {
                    System.arraycopy(object2, n9, this.inBufByte, this.numDataBytes, n3);
                }
                if (n3 < n8) {
                    n2 |= 2;
                }
                buffer.setOffset(n9 + n3);
                buffer.setLength(n8 - n3);
                if (n8 == n3) {
                    buffer.setOffset(0);
                }
                if (n3 > 0) {
                    this.numDataBytes += n3;
                }
                if (this.numDataBytes < this.inBytesReq[0]) {
                    int n10 = n2 | 0 | 4;
                    return n10;
                }
            } else if (this.inputEOMFlag) {
                if (this.processEOMFlag) {
                    this.propagateEOM(buffer2);
                    int n11 = 0;
                    return n11;
                }
            } else {
                n2 |= 2;
            }
            ++this.frameNumber;
            if ((buffer.getFlags() & 0x1000) == 0) {
                if (this.resetFlag) {
                    this.accumulatedTimeNs = buffer.getTimeStamp();
                    this.dAccumulatedTime = 1.0 * (double)this.accumulatedTimeNs;
                    this.resetFlag = false;
                }
                buffer2.setTimeStamp(this.accumulatedTimeNs);
                this.dAccumulatedTime += this.deltaPictureTimeNS;
                this.accumulatedTimeNs = (long)this.dAccumulatedTime;
            } else {
                buffer2.setTimeStamp(buffer.getTimeStamp());
            }
            buffer2.setSequenceNumber(this.frameNumber);
            buffer2.setFlags(buffer2.getFlags() | 0x20);
            object2 = this.validateData(buffer2, 0, true);
            long l2 = this.getNativeData(object2);
            int n12 = this.videoDecode(this.pdata[0], this.inBufByte, this.inDataOffset, this.numDataBytes, this.numFramesBehind, object2, l2, 0, this.outputFormat.getMaxDataLength(), this.imgWidth, this.imgHeight, this.imgType, this.inBytesRead, this.outBufWrote, this.inBytesReq);
            if (n12 != 0) {
                if (n12 == -5) {
                    this.propagateEOM(buffer2);
                    this.processEOMFlag = true;
                    n3 = 0;
                    return n3;
                }
                System.out.println("MPEG VIDEO: decode process error  rc:" + n12);
                System.out.flush();
                this.corruptedFlag = true;
                n3 = 1;
                return n3;
            }
            this.updateOutput(buffer2, this.outputFormat, this.outBufWrote[0], 0);
            this.numDataBytes -= this.inBytesRead[0];
            this.inDataOffset += this.inBytesRead[0];
            if (this.outBufWrote[0] == 0) {
                buffer2.setDiscard(true);
                n2 |= 4;
                if (this.imgType[0] != 0) {
                    ++this.dropCount;
                }
            }
            n3 = n2 | 0;
            return n3;
        }
    }

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    protected void propagateEOM(Buffer buffer) {
        super.propagateEOM(buffer);
        buffer.setTimeStamp(this.accumulatedTimeNs);
        this.dAccumulatedTime += this.deltaPictureTimeNS;
        this.accumulatedTimeNs = (long)this.dAccumulatedTime;
    }

    void setMpegFramesBehind(int n2) {
        this.numFramesBehind = n2;
    }

    static {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpegv");
            available = true;
        }
        catch (Exception exception) {
            available = false;
        }
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        DC() {
        }

        public int getFramesDropped() {
            return 0;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean setMinimalProcessing(boolean bl) {
            MpegVideo.this.setMpegFramesBehind(5);
            return true;
        }

        public void setFramesBehind(float f2) {
            MpegVideo.this.setMpegFramesBehind((int)f2);
        }

        public float setQuality(float f2) {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return false;
        }
    }
}

