/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.codec.video.jpeg.NativeEncoder;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.format.AviVideoFormat;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeEncoder
extends BasicCodec {
    private RGBFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private static boolean loaded = false;
    private static boolean canLoad = true;
    private int peer = 0;
    private static int QSCALE = 99;
    private float quality = 0.6f;
    private float prevQuality = 0.0f;
    private boolean isMotionJPEG = false;
    private boolean firstFrame = true;
    private int PACKET_SIZE = 960;
    private int currentSeq = (int)System.currentTimeMillis();
    private long timestamp = (long)((double)System.currentTimeMillis() * Math.random());
    private byte[] rtp_data = null;
    static Integer processLock = new Integer(1);
    private int copyLength = this.PACKET_SIZE;
    private boolean newframe = true;
    private int current_offset = 0;
    int returnVal = 0;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private static final int DEFAULT_FRAMERATE = 15;
    private byte[] mjpgExtraBytes = new byte[]{44, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 8, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0};

    public NativeEncoder() {
        this.inputFormats = new RGBFormat[1];
        this.inputFormats[0] = new RGBFormat();
        this.outputFormats = new VideoFormat[2];
        this.outputFormats[0] = new JPEGFormat();
        this.outputFormats[1] = new VideoFormat("mjpg");
        class QCA
        extends QualityAdapter
        implements Owned {
            private final /* synthetic */ NativeEncoder this$0;

            public QCA(NativeEncoder nativeEncoder) {
                super(0.6f, 0.0f, 1.0f, true);
                this.this$0 = nativeEncoder;
            }

            public float setQuality(float f2) {
                NativeEncoder.access$002(this.this$0, super.setQuality(f2));
                return NativeEncoder.access$000(this.this$0);
            }

            public String getName() {
                return "JPEG Quality";
            }

            public Object getOwner() {
                return this.this$0;
            }
        }
        QCA qCA = new QCA(this);
        FrameProcessingControl frameProcessingControl = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean bl) {
                NativeEncoder.this.minimal = bl;
                return NativeEncoder.this.minimal;
            }

            public void setFramesBehind(float f2) {
                if (f2 >= 1.0f) {
                    NativeEncoder.this.dropFrame = true;
                } else {
                    NativeEncoder.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[2];
        this.controls[0] = qCA;
        this.controls[1] = frameProcessingControl;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    protected float qfToQuality(float f2) {
        if (f2 < 0.1f) {
            f2 = 0.1f;
        }
        if (this.isMotionJPEG) {
            return f2 * (float)QSCALE;
        }
        if (f2 < 0.8f) {
            return f2 * 1.25f * (float)QSCALE;
        }
        return QSCALE;
    }

    protected int qfToDecimation(float f2) {
        if (this.isMotionJPEG) {
            return 2;
        }
        if (f2 >= 0.8f) {
            if (f2 >= 0.9f) {
                return 4;
            }
            return 2;
        }
        return 1;
    }

    protected int qfToType(float f2) {
        switch (this.qfToDecimation(f2)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(format)) {
            return new Format[0];
        }
        Format[] formatArray = new Format[2];
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n2 = dimension.width * dimension.height * 3;
        JPEGFormat jPEGFormat = new JPEGFormat(dimension, n2, Format.byteArray, rGBFormat.getFrameRate(), -1, -1);
        AviVideoFormat aviVideoFormat = new AviVideoFormat("mjpg", dimension, n2, Format.byteArray, rGBFormat.getFrameRate(), 1, 24, n2, 0, 0, 0, 0, this.mjpgExtraBytes);
        formatArray[0] = jPEGFormat;
        formatArray[1] = aviVideoFormat;
        return formatArray;
    }

    private boolean verifyInputFormat(Format format) {
        if (!(format instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        return rGBFormat.getDataType() == Format.byteArray && rGBFormat.getBitsPerPixel() == 24 && rGBFormat.getRedMask() == 3 && rGBFormat.getGreenMask() == 2 && rGBFormat.getBlueMask() == 1 && rGBFormat.getSize() != null && rGBFormat.getLineStride() >= rGBFormat.getSize().width && rGBFormat.getPixelStride() == 3;
    }

    public Format setInputFormat(Format format) {
        if (!this.verifyInputFormat(format)) {
            return null;
        }
        this.inputFormat = (RGBFormat)format;
        if (this.opened) {
            this.close();
            Dimension dimension = this.inputFormat.getSize();
            int n2 = dimension.width * dimension.height * 3;
            this.outputFormat = this.outputFormat instanceof JPEGFormat ? new JPEGFormat(dimension, n2, Format.byteArray, this.inputFormat.getFrameRate(), (int)this.qfToQuality(this.quality), this.qfToType(this.quality)) : new AviVideoFormat("mjpg", dimension, n2, Format.byteArray, this.inputFormat.getFrameRate(), 1, 24, n2, 0, 0, 0, 0, this.mjpgExtraBytes);
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)format;
        this.isMotionJPEG = this.outputFormat.getEncoding().equalsIgnoreCase("mjpg");
        return format;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        Dimension dimension = this.inputFormat.getSize();
        if (dimension == null || dimension.width % 8 != 0 || dimension.height % 8 != 0) {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes of multiple of 8 pixels.");
            throw new ResourceUnavailableException("Unable to encode in size " + dimension);
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG encoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the JPEG encoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            this.peer = this.initJPEGEncoder(dimension.width, dimension.height, (int)this.qfToQuality(this.quality), this.qfToDecimation(this.quality));
            this.firstFrame = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG encoder");
        }
        super.open();
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGEncoder(this.peer);
        }
        this.peer = 0;
        super.close();
    }

    public void reset() {
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        int n2;
        float f2;
        Object var3_3 = null;
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.minimal || this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        Format format = buffer.getFormat();
        Object object = this.getInputData(buffer);
        long l2 = this.getNativeData(object);
        boolean bl = ((RGBFormat)format).getFlipped() == 1;
        byte[] byArray = (byte[])buffer2.getData();
        if (byArray == null || byArray.length < this.outputFormat.getMaxDataLength()) {
            byArray = new byte[this.outputFormat.getMaxDataLength()];
            buffer2.setData(byArray);
        }
        buffer2.setFormat(this.outputFormat);
        if (this.prevQuality != this.quality) {
            this.prevQuality = this.quality;
            f2 = this.qfToQuality(this.quality);
            this.outputFormat = new JPEGFormat(this.outputFormat.getSize(), this.outputFormat.getMaxDataLength(), Format.byteArray, this.outputFormat.getFrameRate(), (int)this.qfToQuality(this.quality), this.qfToType(this.quality));
            this.close();
            n2 = this.firstFrame ? this.qfToDecimation(this.quality) : -1;
        } else {
            f2 = -1.0f;
            n2 = -1;
        }
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return 1;
            }
        }
        Dimension dimension = this.inputFormat.getSize();
        Integer n3 = processLock;
        synchronized (n3) {
            this.returnVal = this.encodeJPEG(this.peer, object, l2, dimension.width, dimension.height, byArray, byArray.length, (int)f2, n2, bl);
        }
        this.firstFrame = false;
        if (this.returnVal > 0) {
            buffer2.setLength(this.returnVal);
            buffer2.setOffset(0);
            buffer.setLength(0);
            buffer2.setFlags(16);
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setFormat(this.outputFormat);
            return 0;
        }
        buffer2.setDiscard(true);
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Encoder";
    }

    private native int initJPEGEncoder(int var1, int var2, int var3, int var4);

    private native int encodeJPEG(int var1, Object var2, long var3, int var5, int var6, byte[] var7, int var8, int var9, int var10, boolean var11);

    private native boolean freeJPEGEncoder(int var1);

    public static void main(String[] stringArray) {
        int n2 = 320;
        int n3 = 240;
        RGBFormat rGBFormat = new RGBFormat(new Dimension(n2, n3), n2 * n3 * 3, Format.byteArray, -1.0f, 24, 1, 2, 3, 3, n2 * 3, 0, -1);
        VideoFormat videoFormat = new VideoFormat("jpeg", new Dimension(n2, n3), n2 * n3 * 3, Format.byteArray, -1.0f);
        NativeEncoder nativeEncoder = new NativeEncoder();
        if (nativeEncoder.setInputFormat(rGBFormat) != null && nativeEncoder.setOutputFormat(videoFormat) != null) {
            try {
                nativeEncoder.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                System.err.println("Couldn't open encoder");
                System.exit(0);
            }
            byte[] byArray = new byte[n2 * n3 * 3];
            System.err.println("Filling rgb data");
            int n4 = 0;
            while (n4 < n2 * n3 * 3) {
                byArray[n4] = (byte)(n4 % 3 * (n4 % n2) % 255);
                ++n4;
            }
            System.err.println("Encoding");
            Buffer buffer = new Buffer();
            buffer.setFormat(rGBFormat);
            buffer.setData(byArray);
            buffer.setLength(n2 * n3 * 3);
            Buffer buffer2 = new Buffer();
            buffer2.setFormat(videoFormat);
            int n5 = nativeEncoder.process(buffer, buffer2);
            System.err.println("Result = " + n5);
            nativeEncoder.close();
        }
        System.exit(0);
    }

    static /* synthetic */ float access$002(NativeEncoder nativeEncoder, float f2) {
        nativeEncoder.quality = f2;
        return nativeEncoder.quality;
    }

    static /* synthetic */ float access$000(NativeEncoder nativeEncoder) {
        return nativeEncoder.quality;
    }
}

