/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class Packetizer
extends BasicCodec {
    public static float[] RATE_TABLE = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static int SEGMENT_DONE = 1;
    protected static int SEGMENT_REPEAT = 2;
    protected static int SEGMENT_DONE_BUFFER_FULL = 3;
    protected static int PACKET_MAX = 1456;
    private static boolean debug = false;
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private boolean inputEOM = false;
    private boolean expectingNewInput = true;
    private boolean expectingNewOutput = true;
    private boolean resetTime = true;
    private boolean resetInProgress = true;
    private Vector outputQueue = new Vector();
    private Vector inputQueue = new Vector();
    private Vector segmentQueue = new Vector();
    private byte[] sequenceHeader = null;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private double frameRate = 0.0;
    private long picNanos = 0L;
    private long gopTime = 0L;
    private long startTime = 1L;
    private long frameTime = 0L;
    private long frameCount = 0L;
    private int sequenceNumber = 0;
    private byte[] mpegHeader = new byte[]{0, 0, 0, 0};

    public Packetizer() {
        this.inputFormats = new Format[]{new VideoFormat("mpeg")};
        this.outputFormats = new Format[]{new VideoFormat("mpeg/rtp")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] formatArray = new Format[]{this.makeMPEGFormat(format)};
        return formatArray;
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeMPEGFormat(format);
        return format;
    }

    private final VideoFormat makeMPEGFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        return new VideoFormat("mpeg/rtp", videoFormat.getSize(), -1, Format.byteArray, videoFormat.getFrameRate());
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on MPEG converter");
        }
        this.startTime = 1L;
        this.frameRate = 0.0;
        this.picNanos = 0L;
        this.sequenceNumber = 0;
        this.resetTime = true;
    }

    public synchronized void close() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.outputQueue.removeAllElements();
        this.inputQueue.removeAllElements();
        this.segmentQueue.removeAllElements();
        this.inputEOM = false;
        this.expectingNewInput = true;
        this.expectingNewOutput = true;
        this.resetInProgress = true;
        this.resetTime = true;
        this.sequenceHeader = null;
        this.frameWidth = 0;
        this.frameHeight = 0;
        this.mpegHeader[0] = 0;
        this.mpegHeader[1] = 0;
        this.mpegHeader[2] = 0;
        this.mpegHeader[3] = 0;
        this.gopTime = 1L;
        this.frameTime = 0L;
        this.frameCount = 0L;
        if (debug) {
            System.err.println("Packetizer(V): reset completed");
        }
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.outputQueue.size() > 0) {
            Buffer buffer3 = (Buffer)this.outputQueue.firstElement();
            this.outputQueue.removeElementAt(0);
            buffer2.setData((byte[])buffer3.getData());
            buffer2.setOffset(buffer3.getOffset());
            buffer2.setLength(buffer3.getLength());
            buffer2.setFlags(buffer3.getFlags());
            buffer2.setTimeStamp(buffer3.getTimeStamp());
            buffer2.setSequenceNumber(this.sequenceNumber++);
            buffer2.setFormat(this.outputFormat);
            this.expectingNewOutput = true;
            return 2;
        }
        if (this.isEOM(buffer)) {
            this.inputEOM = true;
            if (this.segmentQueue.isEmpty()) {
                this.propagateEOM(buffer2);
                buffer2.setSequenceNumber(this.sequenceNumber++);
                return 0;
            }
        }
        if (buffer.isDiscard()) {
            this.updateOutput(buffer2, this.outputFormat, 0, 0);
            buffer2.setDiscard(true);
            return 4;
        }
        int n2 = 1;
        try {
            n2 = this.doProcess(buffer, buffer2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        if (this.outputFormat == null) {
            this.outputFormat = this.makeMPEGFormat(buffer.getFormat());
        }
        if (n2 != 4) {
            buffer2.setSequenceNumber(this.sequenceNumber++);
        }
        return n2;
    }

    public String getName() {
        return "MPEG Video Packetizer";
    }

    public void finalize() {
        this.close();
    }

    private int doProcess(Buffer buffer, Buffer buffer2) {
        Object object;
        if (this.expectingNewInput) {
            if (!this.inputEOM) {
                if (buffer.getData() == null) {
                    return 4;
                }
                if (this.resetTime) {
                    this.startTime = buffer.getTimeStamp();
                    if (debug) {
                        System.err.println("Packetizer(V): new synctime set: " + this.startTime);
                    }
                    if (this.startTime == 0L) {
                        this.startTime = 1L;
                    }
                    this.resetTime = false;
                }
                this.inputQueue.addElement(this.copyInto(buffer));
            }
            this.expectingNewInput = false;
        }
        if (this.expectingNewOutput) {
            object = (byte[])buffer2.getData();
            if (object == null || ((byte[])object).length < PACKET_MAX) {
                object = new byte[PACKET_MAX];
                buffer2.setData(object);
            }
            System.arraycopy(this.mpegHeader, 0, object, 0, 4);
            buffer2.setOffset(0);
            buffer2.setLength(4);
            buffer2.setFlags(0);
            buffer2.setHeader(null);
            buffer2.setFormat(this.outputFormat);
            this.expectingNewOutput = false;
        }
        if (this.segmentQueue.isEmpty()) {
            this.findFirstStartCode();
            if (this.segmentQueue.isEmpty()) {
                this.expectingNewInput = true;
                return 4;
            }
        }
        object = (MPEGSegment)this.segmentQueue.firstElement();
        while (object != null) {
            if (object.getLength() < 0) {
                this.expectingNewInput = true;
                return 4;
            }
            int n2 = object.startCode;
            int n3 = 0;
            n3 = n2 == 179 ? this.doSequenceHeader((MPEGSegment)object, buffer2) : (n2 == 183 ? this.doSequenceEnd((MPEGSegment)object, buffer2) : (n2 == 184 ? this.doGOP((MPEGSegment)object, buffer2) : (n2 == 0 ? this.doPicture((MPEGSegment)object, buffer2) : (n2 >= 1 && n2 <= 175 ? this.doSlice((MPEGSegment)object, buffer2) : SEGMENT_DONE))));
            if (n3 == SEGMENT_DONE) {
                this.segmentQueue.removeElementAt(0);
                if (this.segmentQueue.isEmpty()) {
                    this.expectingNewInput = true;
                    if (buffer2.getLength() > 4) {
                        return 0;
                    }
                    return 4;
                }
                object = (MPEGSegment)this.segmentQueue.firstElement();
                continue;
            }
            if (n3 == SEGMENT_DONE_BUFFER_FULL) {
                this.segmentQueue.removeElementAt(0);
                buffer2.setFlags(buffer2.getFlags() | 0x20);
                if (this.expectingNewInput) {
                    return 0;
                }
                return 2;
            }
            if (n3 != SEGMENT_REPEAT) continue;
            buffer2.setFlags(buffer2.getFlags() | 0x20);
            if (this.expectingNewInput) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private Buffer copyInto(Buffer buffer) {
        Buffer buffer2 = new Buffer();
        buffer2.copy(buffer);
        buffer2.setFlags(buffer2.getFlags() | 0x20);
        buffer.setData(null);
        buffer.setHeader(null);
        buffer.setLength(0);
        buffer.setOffset(0);
        return buffer2;
    }

    protected String toHex(byte[] byArray, int n2) {
        String string = new String();
        int n3 = 0;
        while (n3 < 4) {
            string = string + hexChar[byArray[n2 + n3] >> 4 & 0xF];
            string = string + hexChar[byArray[n2 + n3] & 0xF];
            ++n3;
        }
        return string;
    }

    private int doSequenceHeader(MPEGSegment mPEGSegment, Buffer buffer) {
        this.sequenceHeader = new byte[mPEGSegment.getLength()];
        mPEGSegment.copyData(this.sequenceHeader, 0);
        this.frameWidth = (this.sequenceHeader[4] & 0xFF) << 4 | (this.sequenceHeader[5] & 0xF0) >> 4;
        this.frameHeight = (this.sequenceHeader[5] & 0xF) << 8 | this.sequenceHeader[6] & 0xFF;
        int n2 = this.sequenceHeader[7] & 0xF;
        if (n2 > 0 && n2 <= 8) {
            this.frameRate = RATE_TABLE[n2];
        }
        this.picNanos = (long)(1.0E9 / this.frameRate);
        return SEGMENT_DONE;
    }

    private int copySequenceHeader(Buffer buffer) {
        if (this.sequenceHeader == null) {
            return 0;
        }
        System.arraycopy(this.sequenceHeader, 0, buffer.getData(), buffer.getLength(), this.sequenceHeader.length);
        buffer.setLength(buffer.getLength() + this.sequenceHeader.length);
        return this.sequenceHeader.length;
    }

    private int doSequenceEnd(MPEGSegment mPEGSegment, Buffer buffer) {
        return SEGMENT_DONE;
    }

    private int doGOP(MPEGSegment mPEGSegment, Buffer buffer) {
        this.gopTime = this.frameCount == 0L ? 1L + this.startTime : this.frameCount * this.picNanos + this.startTime;
        this.copySequenceHeader(buffer);
        mPEGSegment.copyData((byte[])buffer.getData(), buffer.getLength());
        buffer.setLength(buffer.getLength() + mPEGSegment.getLength());
        return SEGMENT_DONE;
    }

    private int doPicture(MPEGSegment mPEGSegment, Buffer buffer) {
        byte[] byArray = new byte[mPEGSegment.getLength()];
        mPEGSegment.copyData(byArray, 0);
        int n2 = (byArray[4] & 0xFF) << 2 | (byArray[5] & 0xC0) >> 6;
        int n3 = (byArray[5] & 0x38) >> 3;
        this.mpegHeader[0] = (byte)(n2 >> 8 & 2);
        this.mpegHeader[1] = (byte)n2;
        this.mpegHeader[2] = (byte)n3;
        if (n3 == 1) {
            this.mpegHeader[3] = 0;
        } else {
            int n4 = (byArray[7] & 7) << 1 | (byArray[8] & 0x80) >> 7;
            if (n3 > 2) {
                n4 |= (byArray[8] & 0x78) << 1;
            }
            this.mpegHeader[3] = (byte)n4;
        }
        this.resetInProgress = false;
        byte[] byArray2 = (byte[])buffer.getData();
        System.arraycopy(this.mpegHeader, 0, byArray2, 0, 4);
        if (buffer.getLength() > 8 && byArray2[4] == 0 && byArray2[5] == 0 && byArray2[6] == 1 && (byArray2[7] & 0xFF) == 179) {
            byArray2[2] = (byte)(byArray2[2] | 0x20);
        }
        mPEGSegment.copyData((byte[])buffer.getData(), buffer.getLength());
        buffer.setLength(buffer.getLength() + mPEGSegment.getLength());
        buffer.setFlags(buffer.getFlags() | 0x10);
        ++this.frameCount;
        this.frameTime = this.gopTime + (long)n2 * this.picNanos;
        buffer.setTimeStamp(this.frameTime);
        buffer.setFormat(this.outputFormat);
        return SEGMENT_DONE;
    }

    private int doSlice(MPEGSegment mPEGSegment, Buffer buffer) {
        byte[] byArray = (byte[])buffer.getData();
        if (mPEGSegment.getLength() < PACKET_MAX - buffer.getLength()) {
            mPEGSegment.copyData(byArray, buffer.getLength());
            buffer.setLength(buffer.getLength() + mPEGSegment.getLength());
            buffer.setTimeStamp(this.frameTime);
            buffer.setFormat(this.outputFormat);
            byArray[2] = (byte)(byArray[2] | 0x18);
            if (this.segmentQueue.size() > 1) {
                MPEGSegment mPEGSegment2 = (MPEGSegment)this.segmentQueue.elementAt(1);
                if (mPEGSegment2.startCode < 1 || mPEGSegment2.startCode > 175) {
                    buffer.setFlags(buffer.getFlags() | 0x800);
                    this.expectingNewOutput = true;
                    return SEGMENT_DONE_BUFFER_FULL;
                }
            } else if (this.inputEOM) {
                buffer.setFlags(buffer.getFlags() | 0x800);
                this.expectingNewOutput = true;
                return SEGMENT_DONE_BUFFER_FULL;
            }
            return SEGMENT_DONE;
        }
        if ((byArray[2] & 0x18) != 0) {
            this.expectingNewOutput = true;
            return SEGMENT_REPEAT;
        }
        int n2 = PACKET_MAX - buffer.getLength();
        mPEGSegment.copyData(0, n2, byArray, buffer.getLength());
        buffer.setLength(buffer.getLength() + n2);
        buffer.setTimeStamp(this.frameTime);
        buffer.setFormat(this.outputFormat);
        byArray[2] = (byte)(byArray[2] | 0x10);
        int n3 = n2;
        n2 = mPEGSegment.getLength() - n2;
        Buffer buffer2 = null;
        while (n2 > 0) {
            buffer2 = new Buffer();
            byArray = new byte[PACKET_MAX];
            buffer2.setData(byArray);
            buffer2.setTimeStamp(this.frameTime);
            buffer2.setHeader(null);
            buffer2.setFormat(this.outputFormat);
            buffer2.setFlags(buffer.getFlags());
            buffer2.setOffset(0);
            System.arraycopy(this.mpegHeader, 0, byArray, 0, 4);
            int n4 = n2;
            if (n2 > PACKET_MAX - 4) {
                n4 = PACKET_MAX - 4;
            }
            mPEGSegment.copyData(n3, n4, (byte[])buffer2.getData(), 4);
            buffer2.setLength(n4 + 4);
            n3 += n4;
            if ((n2 -= n4) <= 0) {
                byArray[2] = (byte)(byArray[2] | 8);
            }
            this.outputQueue.addElement(buffer2);
        }
        if (this.segmentQueue.size() > 1) {
            MPEGSegment mPEGSegment3 = (MPEGSegment)this.segmentQueue.elementAt(1);
            if (mPEGSegment3.startCode < 1 || mPEGSegment3.startCode > 175) {
                buffer2.setFlags(buffer2.getFlags() | 0x800);
                this.expectingNewOutput = true;
                return SEGMENT_DONE_BUFFER_FULL;
            }
        } else if (this.inputEOM) {
            buffer2.setFlags(buffer2.getFlags() | 0x800);
            this.expectingNewOutput = true;
            return SEGMENT_DONE_BUFFER_FULL;
        }
        this.expectingNewOutput = true;
        return SEGMENT_DONE_BUFFER_FULL;
    }

    private void findFirstStartCode() {
        if (this.inputQueue.isEmpty()) {
            return;
        }
        Buffer buffer = (Buffer)this.inputQueue.firstElement();
        this.inputQueue.removeElementAt(0);
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        while (n3 > 4) {
            if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 1 && (byArray[n2 + 3] & 0xFF) != 181 && (byArray[n2 + 3] & 0xFF) != 178) {
                if (this.resetInProgress) {
                    if ((byArray[n2 + 3] & 0xFF) == 179 || (byArray[n2 + 3] & 0xFF) == 184) {
                        MPEGSegment mPEGSegment = new MPEGSegment(byArray[n2 + 3] & 0xFF, n2, buffer);
                        this.segmentQueue.addElement(mPEGSegment);
                        return;
                    }
                } else {
                    MPEGSegment mPEGSegment = new MPEGSegment(byArray[n2 + 3] & 0xFF, n2, buffer);
                    this.segmentQueue.addElement(mPEGSegment);
                    return;
                }
            }
            ++n2;
            --n3;
        }
        this.expectingNewInput = true;
    }

    class MPEGSegment {
        int startCode = -1;
        int offset = -1;
        int length = -1;
        Buffer startBuffer = null;
        Buffer endBuffer = null;

        MPEGSegment(int n2, int n3, Buffer buffer) {
            this.startCode = n2;
            this.offset = n3;
            this.startBuffer = buffer;
        }

        void copyData(byte[] byArray, int n2) {
            this.copyData(0, this.length, byArray, n2);
        }

        void copyData(int n2, byte[] byArray, int n3) {
            this.copyData(n2, this.length - n2, byArray, n3);
        }

        void copyData(int n2, int n3, byte[] byArray, int n4) {
            if (n2 + n3 > this.length) {
                n3 = this.length - n2;
            }
            if (this.endBuffer == null) {
                System.arraycopy(this.startBuffer.getData(), this.offset + n2, byArray, n4, n3);
                return;
            }
            int n5 = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
            int n6 = this.length - n5;
            if (n2 + n3 <= n5) {
                System.arraycopy(this.startBuffer.getData(), this.offset + n2, byArray, n4, n3);
                return;
            }
            if (n2 >= n5) {
                System.arraycopy(this.endBuffer.getData(), this.endBuffer.getOffset() + (n2 -= n5), byArray, n4, n3);
                return;
            }
            int n7 = n5 - n2;
            System.arraycopy(this.startBuffer.getData(), this.offset + n2, byArray, n4, n7);
            System.arraycopy(this.endBuffer.getData(), this.endBuffer.getOffset(), byArray, n4 + n7, n3 -= n7);
        }

        int getLength() {
            if (this.length < 0) {
                this.calculateLength();
            }
            return this.length;
        }

        private void calculateLength() {
            if (this.length > 0) {
                return;
            }
            int n2 = this.findNextStart();
            if (n2 > this.offset) {
                this.length = n2 - this.offset;
                return;
            }
            if (Packetizer.this.inputEOM) {
                this.length = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
                return;
            }
            if (this.endBuffer == null) {
                if (Packetizer.this.inputQueue.isEmpty()) {
                    return;
                }
                this.endBuffer = (Buffer)Packetizer.this.inputQueue.firstElement();
                Packetizer.this.inputQueue.removeElementAt(0);
            }
            if ((n2 = this.findNextStartBetweenBuffers()) > this.offset) {
                this.length = n2 - this.offset;
                return;
            }
            n2 = this.findNextStartInEndBuffer();
            this.length = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
            this.length += n2 - this.endBuffer.getOffset();
        }

        private int findNextStart() {
            byte[] byArray = (byte[])this.startBuffer.getData();
            int n2 = this.offset + 4;
            int n3 = this.startBuffer.getLength() - (this.offset + 4 - this.startBuffer.getOffset());
            while (n3 > 3) {
                if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 1 && (byArray[n2 + 3] & 0xFF) != 181 && (byArray[n2 + 3] & 0xFF) != 178) {
                    MPEGSegment mPEGSegment = new MPEGSegment(byArray[n2 + 3] & 0xFF, n2, this.startBuffer);
                    Packetizer.this.segmentQueue.addElement(mPEGSegment);
                    return n2;
                }
                ++n2;
                --n3;
            }
            return -1;
        }

        private int findNextStartBetweenBuffers() {
            byte[] byArray = (byte[])this.startBuffer.getData();
            byte[] byArray2 = (byte[])this.endBuffer.getData();
            int n2 = this.startBuffer.getOffset() + this.startBuffer.getLength() - 3;
            if (n2 <= this.offset) {
                return -1;
            }
            int n3 = this.endBuffer.getOffset();
            if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 1 && (byArray2[n3] & 0xFF) != 181 && (byArray[n3] & 0xFF) != 178) {
                MPEGSegment mPEGSegment = new MPEGSegment(byArray2[n3] & 0xFF, n2, this.startBuffer);
                mPEGSegment.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(mPEGSegment);
                this.endBuffer = null;
                return n2;
            }
            if (byArray[n2 + 1] == 0 && byArray[n2 + 2] == 0 && byArray2[n3] == 1 && (byArray2[n3 + 1] & 0xFF) != 181 && (byArray[n3 + 1] & 0xFF) != 178) {
                MPEGSegment mPEGSegment = new MPEGSegment(byArray2[n3 + 1] & 0xFF, n2 + 1, this.startBuffer);
                mPEGSegment.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(mPEGSegment);
                this.endBuffer = null;
                return n2 + 1;
            }
            if (byArray[n2 + 2] == 0 && byArray2[n3] == 0 && byArray2[n3 + 1] == 1 && (byArray2[n3 + 2] & 0xFF) != 181 && (byArray[n3 + 2] & 0xFF) != 178) {
                MPEGSegment mPEGSegment = new MPEGSegment(byArray2[n3 + 2] & 0xFF, n2 + 2, this.startBuffer);
                mPEGSegment.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(mPEGSegment);
                this.endBuffer = null;
                return n2 + 2;
            }
            return -1;
        }

        private int findNextStartInEndBuffer() {
            byte[] byArray = (byte[])this.endBuffer.getData();
            int n2 = this.endBuffer.getOffset();
            int n3 = this.endBuffer.getLength();
            while (n3 > 3) {
                if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 1 && (byArray[n2 + 3] & 0xFF) != 181 && (byArray[n2 + 3] & 0xFF) != 178) {
                    MPEGSegment mPEGSegment = new MPEGSegment(byArray[n2 + 3] & 0xFF, n2, this.endBuffer);
                    Packetizer.this.segmentQueue.addElement(mPEGSegment);
                    return n2;
                }
                ++n2;
                --n3;
            }
            return -1;
        }
    }
}

