/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtsp;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.content.rtsp.RtspUtil;
import com.sun.media.controls.RtspAdapter;
import com.sun.media.protocol.BufferListener;
import com.sun.media.rtsp.Timer;
import com.sun.media.rtsp.TimerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.renderer.VisualContainer;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;

public class Handler
extends BasicPlayer
implements ReceiveStreamListener,
TimerListener,
BufferListener {
    private final int INITIALIZED = 0;
    private final int REALIZED = 1;
    private final int PLAYING = 2;
    private final int PAUSING = 3;
    private RtspUtil rtspUtil;
    private Player[] players;
    private Vector playerList;
    private boolean dataReceived;
    private com.sun.media.protocol.rtp.DataSource[] data_sources;
    private boolean[] track_ready;
    private String url;
    private Object readySync = new Object();
    private Object stateSync = new Object();
    private boolean waitFailed;
    private int state;
    private boolean first_pass = true;
    private Timer timer;
    private Container container = null;

    public Handler() {
        this.rtspUtil = new RtspUtil(this);
        this.framePositioning = false;
        this.playerList = new Vector();
        this.state = 0;
        this.stopThreadEnabled = true;
    }

    protected synchronized boolean doRealize() {
        boolean bl = super.doRealize();
        if (bl) {
            bl = this.initRtspSession();
            if (!bl) {
                this.processError = this.rtspUtil.getProcessError();
            } else {
                long l2 = this.rtspUtil.getDuration();
                if (l2 > 0L) {
                    this.sendEvent(new DurationUpdateEvent(this, new Time(l2)));
                }
            }
        }
        return bl;
    }

    private boolean initRtspSession() {
        int n2;
        boolean bl = false;
        this.rtspUtil.setUrl(this.url);
        String string = this.rtspUtil.getServerIpAddress();
        if (string == null) {
            Log.error("Invalid server address");
            this.rtspUtil.setProcessError("Invalid server address");
            bl = false;
        } else {
            bl = this.rtspUtil.createConnection();
            if (bl) {
                bl = this.rtspUtil.rtspSetup();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    n2 = this.rtspUtil.getNumberOfTracks();
                    int[] nArray = this.rtspUtil.getServerPorts();
                    int n3 = 0;
                    while (n3 < n2) {
                        SessionAddress sessionAddress = new SessionAddress(inetAddress, nArray[n3]);
                        RTPManager rTPManager = this.rtspUtil.getRTPManager(n3);
                        rTPManager.addTarget(sessionAddress);
                        BufferControl bufferControl = (BufferControl)rTPManager.getControl("javax.media.control.BufferControl");
                        String string2 = this.rtspUtil.getMediaType(n3);
                        if (string2.equals("audio")) {
                            bufferControl.setBufferLength(250L);
                            bufferControl.setMinimumThreshold(125L);
                        } else if (string2.equals("video")) {
                            bufferControl.setBufferLength(1500L);
                            bufferControl.setMinimumThreshold(250L);
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    Log.error(exception.getMessage());
                    return bl;
                }
            }
        }
        if (bl) {
            this.state = 1;
            int n4 = this.rtspUtil.getNumberOfTracks();
            this.players = new Player[n4];
            this.data_sources = new com.sun.media.protocol.rtp.DataSource[n4];
            this.track_ready = new boolean[n4];
            this.dataReceived = false;
            if (!this.rtspUtil.rtspStart()) {
                if (this.first_pass && this.rtspUtil.getStatusCode() == 454) {
                    this.first_pass = false;
                    this.playerList = new Vector();
                    return this.initRtspSession();
                }
                return false;
            }
            this.waitForData();
            if (this.playerList.size() > 0) {
                this.rtspStop();
                this.rtspUtil.setStartPos(0.0);
                n2 = 0;
                while (n2 < this.rtspUtil.getNumberOfTracks()) {
                    this.data_sources[n2].flush();
                    ++n2;
                }
            } else {
                this.rtspUtil.setProcessError("Media tracks not supported");
                bl = false;
            }
        }
        return bl;
    }

    public boolean doPrefetch() {
        boolean bl = super.doPrefetch();
        return bl;
    }

    public void doStart() {
        if (this.state >= 1 && this.state != 2) {
            int n2 = 0;
            while (n2 < this.rtspUtil.getNumberOfTracks()) {
                this.track_ready[n2] = this.rtspUtil.getRTPManager(n2) == null;
                this.data_sources[n2].prebuffer();
                ++n2;
            }
            boolean bl = this.rtspUtil.rtspStart();
            Object object = this.readySync;
            synchronized (object) {
                boolean bl2 = true;
                int n3 = 0;
                while (n3 < this.rtspUtil.getNumberOfTracks()) {
                    if (!this.track_ready[n3]) {
                        bl2 = false;
                        break;
                    }
                    ++n3;
                }
                if (!bl2) {
                    try {
                        this.readySync.wait(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                super.doStart();
                this.startPlayers();
                this.state = 2;
                long l2 = this.rtspUtil.getDuration();
                if (l2 > 0L) {
                    this.timer = new Timer(this, l2 + 500000000L - this.getMediaTime().getNanoseconds());
                    this.timer.start();
                }
            }
        }
    }

    public void doSetMediaTime(Time time) {
        super.doSetMediaTime(time);
        this.rtspUtil.setStartPos(time.getNanoseconds());
        int n2 = 0;
        while (n2 < this.rtspUtil.getNumberOfTracks()) {
            this.data_sources[n2].flush();
            ++n2;
        }
    }

    public Time getMediaTime() {
        Time time = super.getMediaTime();
        return time;
    }

    public void timerExpired() {
        this.timer = null;
        this.processEndOfMedia();
    }

    public void doStop() {
        if (this.state == 2) {
            super.doStop();
            if (this.timer != null) {
                this.timer.stopTimer();
                this.timer.removeListener(this);
                this.timer = null;
            }
            this.stopPlayers();
            this.rtspStop();
            this.state = 3;
        }
    }

    public void rtspStop() {
        this.rtspUtil.setStartPos(this.getMediaTime().getNanoseconds());
        this.rtspUtil.rtspStop();
    }

    public void doClose() {
        this.stopPlayers();
        this.closePlayers();
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer.removeListener(this);
            this.timer = null;
        }
        if (this.state == 2) {
            this.rtspUtil.rtspTeardown();
        }
        this.state = 0;
        this.rtspUtil.closeConnection();
        int n2 = 0;
        while (n2 < this.rtspUtil.getNumberOfTracks()) {
            RTPManager rTPManager = this.rtspUtil.getRTPManager(n2);
            rTPManager.removeTargets("server down.");
            rTPManager.dispose();
            ++n2;
        }
        super.doClose();
    }

    public float setRate(float f2) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        return 1.0f;
    }

    public void setStopTime(Time time) {
        this.controllerSetStopTime(time);
    }

    protected void stopAtTime() {
        this.controllerStopAtTime();
    }

    public synchronized void addController(Controller controller) throws IncompatibleTimeBaseException {
        int n2 = this.getState();
        if (n2 == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (n2 == 100 || n2 == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        throw new IncompatibleTimeBaseException();
    }

    public boolean audioEnabled() {
        boolean bl = true;
        return bl;
    }

    public boolean videoEnabled() {
        boolean bl = true;
        return bl;
    }

    public void updateStats() {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    public synchronized void update(ReceiveStreamEvent receiveStreamEvent) {
        RTPManager rTPManager = (RTPManager)receiveStreamEvent.getSource();
        if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
            Duration duration;
            ReceiveStream receiveStream = ((NewReceiveStreamEvent)receiveStreamEvent).getReceiveStream();
            Participant participant = receiveStream.getParticipant();
            int n2 = this.rtspUtil.getNumberOfTracks();
            int n3 = 0;
            while (n3 < n2) {
                if (rTPManager == this.rtspUtil.getRTPManager(n3)) {
                    duration = (com.sun.media.protocol.rtp.DataSource)receiveStream.getDataSource();
                    try {
                        this.players[n3] = Manager.createPlayer((DataSource)duration);
                    }
                    catch (Exception exception) {
                        System.err.println("Failed to create a player from the given Data Source: " + exception);
                    }
                    try {
                        this.waitFailed = false;
                        this.players[n3].addControllerListener(new StateListener());
                        this.players[n3].realize();
                        this.waitForState(this.players[n3], 300);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.players[n3].getState() == 300) {
                        this.playerList.addElement(this.players[n3]);
                        ((com.sun.media.protocol.rtp.DataSource)duration).setBufferListener(this);
                        this.data_sources[n3] = duration;
                        break;
                    }
                    this.players[n3].close();
                    this.players[n3] = null;
                    this.rtspUtil.removeTrack(n3);
                    break;
                }
                ++n3;
            }
            if (this.playerList.size() == this.rtspUtil.getNumberOfTracks()) {
                this.dataReceived = true;
                duration = this;
                synchronized (duration) {
                    this.notifyAll();
                }
            }
        } else if (receiveStreamEvent instanceof ByeEvent) {
            // empty if block
        }
    }

    public void minThresholdReached(DataSource dataSource) {
        Object object = this.readySync;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.rtspUtil.getNumberOfTracks()) {
                if (dataSource == this.data_sources[n2]) {
                    this.track_ready[n2] = true;
                    break;
                }
                ++n2;
            }
            boolean bl = true;
            int n3 = 0;
            while (n3 < this.rtspUtil.getNumberOfTracks()) {
                if (!this.track_ready[n3]) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                this.readySync.notifyAll();
            }
        }
    }

    public long getMediaNanoseconds() {
        long l2 = super.getMediaNanoseconds();
        return l2;
    }

    public Time getDuration() {
        long l2 = this.rtspUtil.getDuration();
        if (l2 <= 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(l2);
    }

    private synchronized void waitForState(Player player, int n2) {
        while (player.getState() < n2 && !this.waitFailed) {
            Object object = this.stateSync;
            synchronized (object) {
                try {
                    this.stateSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean waitForData() {
        try {
            Handler handler = this;
            synchronized (handler) {
                while (!this.dataReceived) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.dataReceived;
    }

    public Component getVisualComponent() {
        Vector<Component> vector = new Vector<Component>(1);
        int n2 = 0;
        while (n2 < this.rtspUtil.getNumberOfTracks()) {
            Component component;
            if (this.players[n2] != null && (component = this.players[n2].getVisualComponent()) != null) {
                vector.addElement(component);
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (Component)vector.elementAt(0);
        }
        return this.createVisualContainer(vector);
    }

    protected Component createVisualContainer(Vector vector) {
        Boolean bl = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = bl == null || bl == false ? new HeavyPanel(vector) : new LightPanel(vector);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            int n2 = 0;
            while (n2 < vector.size()) {
                Component component = (Component)vector.elementAt(n2);
                this.container.add(component);
                component.setSize(component.getPreferredSize());
                ++n2;
            }
        }
        return this.container;
    }

    public GainControl getGainControl() {
        GainControl gainControl = null;
        int n2 = 0;
        while (n2 < this.playerList.size()) {
            Player player = (Player)this.playerList.elementAt(n2);
            gainControl = player.getGainControl();
            if (gainControl != null) break;
            ++n2;
        }
        return gainControl;
    }

    public Control[] getControls() {
        Control[] controlArray;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.playerList.size()) {
            controlArray = ((Player)this.playerList.elementAt(n3)).getControls();
            n2 += controlArray.length;
            ++n3;
        }
        controlArray = new Control[++n2];
        RtspAdapter rtspAdapter = new RtspAdapter();
        rtspAdapter.setRTPManagers(this.rtspUtil.getRTPManagers());
        rtspAdapter.setMediaTypes(this.rtspUtil.getMediaTypes());
        int n4 = 0;
        controlArray[n4++] = rtspAdapter;
        int n5 = 0;
        while (n5 < this.playerList.size()) {
            Control[] controlArray2 = ((Player)this.playerList.elementAt(n5)).getControls();
            int n6 = 0;
            while (n6 < controlArray2.length) {
                controlArray[n4++] = controlArray2[n6];
                ++n6;
            }
            ++n5;
        }
        return controlArray;
    }

    private void startPlayers() {
        int n2 = 0;
        while (n2 < this.playerList.size()) {
            Player player = (Player)this.playerList.elementAt(n2);
            player.start();
            ++n2;
        }
    }

    private void stopPlayers() {
        int n2 = 0;
        while (n2 < this.playerList.size()) {
            Player player = (Player)this.playerList.elementAt(n2);
            player.stop();
            ++n2;
        }
    }

    private void closePlayers() {
        int n2 = 0;
        while (n2 < this.playerList.size()) {
            Player player = (Player)this.playerList.elementAt(n2);
            player.close();
            ++n2;
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (dataSource instanceof com.sun.media.protocol.rtsp.DataSource) {
            MediaLocator mediaLocator = dataSource.getLocator();
            try {
                this.url = mediaLocator.toString();
            }
            catch (Exception exception) {
                throw new IncompatibleSourceException();
            }
        } else {
            throw new IncompatibleSourceException();
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector vector) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector vector) {
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            Object object;
            if (controllerEvent instanceof ControllerClosedEvent) {
                // empty if block
            }
            if (controllerEvent instanceof ResourceUnavailableEvent) {
                Handler.this.waitFailed = true;
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (controllerEvent instanceof RealizeCompleteEvent) {
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (controllerEvent instanceof ControllerEvent) {
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (controllerEvent instanceof EndOfMediaEvent) {
                // empty if block
            }
        }
    }
}

