/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.ui.SliderComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.QualityControl;

public class QualityAdapter
implements QualityControl,
ActionListener {
    protected float preferredValue;
    protected float minValue;
    protected float maxValue;
    protected float value;
    protected boolean settable;
    protected boolean isTSsupported;
    protected SliderComp sliderComp = null;
    private float scale = 100.0f;

    public QualityAdapter(float f2, float f3, float f4, boolean bl) {
        this(f2, f3, f4, false, bl);
    }

    public QualityAdapter(float f2, float f3, float f4, boolean bl, boolean bl2) {
        this.preferredValue = f2;
        this.minValue = f3;
        this.maxValue = f4;
        this.value = f2;
        this.settable = bl2;
        this.isTSsupported = bl;
    }

    public float getQuality() {
        return this.value;
    }

    public float setQuality(float f2) {
        if (f2 < this.minValue) {
            f2 = this.minValue;
        } else if (f2 > this.maxValue) {
            f2 = this.maxValue;
        }
        this.value = f2;
        if (this.sliderComp != null) {
            this.sliderComp.setValue(this.value * this.scale);
        }
        if (this.settable) {
            return this.value;
        }
        return -1.0f;
    }

    public float getPreferredQuality() {
        return this.preferredValue;
    }

    public boolean isTemporalSpatialTradeoffSupported() {
        return this.isTSsupported;
    }

    protected String getName() {
        return "Quality";
    }

    public Component getControlComponent() {
        if (this.sliderComp == null) {
            this.sliderComp = new SliderComp(this.getName(), this.minValue * this.scale, this.maxValue * this.scale, this.value * this.scale);
            this.sliderComp.setActionListener(this);
        }
        return this.sliderComp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f2 = this.sliderComp.getFloatValue() / this.scale;
        this.setQuality(f2);
    }
}

