/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AIFFMux
extends BasicMux {
    private Format format;
    private AudioFormat audioFormat;
    private int sampleSizeInBits;
    private double sampleRate;
    private int channels;
    private int blockAlign = 1;
    private int dataSizeOffset;
    private int maxFrames = 0;
    private int maxFramesOffset = 0;
    private String formType;
    private String aiffEncoding;
    private int headerSize = 0;
    private int dataSize = 0;
    private static int AIFCVersion1 = -1568648896;
    private static final String FormID = "FORM";
    private static final String FormatVersionID = "FVER";
    private static final String CommonID = "COMM";
    private static final String SoundDataID = "SSND";
    private static final int CommonIDSize = 18;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, 1);

    public AIFFMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.x_aiff");
    }

    public String getName() {
        return "AIFF Audio Multiplexer";
    }

    public int setNumTracks(int n2) {
        if (n2 != 1) {
            return 1;
        }
        return super.setNumTracks(n2);
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteBytes(FormID);
        this.bufWriteInt(0);
        this.bufWriteBytes(this.formType);
        if (this.formType.equals("AIFC")) {
            this.bufWriteBytes(FormatVersionID);
            this.bufWriteInt(4);
            this.bufWriteInt(AIFCVersion1);
        }
        this.bufWriteBytes(CommonID);
        int n2 = 18;
        if (this.formType.equals("AIFC")) {
            n2 += 8;
        }
        this.bufWriteInt(n2);
        this.bufWriteShort((short)this.channels);
        this.maxFramesOffset = this.filePointer;
        this.bufWriteInt(this.maxFrames);
        this.bufWriteShort((short)this.sampleSizeInBits);
        int n3 = 16398;
        double d2 = this.sampleRate;
        while (d2 < 44000.0) {
            d2 *= 2.0;
            --n3;
        }
        this.bufWriteShort((short)n3);
        this.bufWriteInt((int)d2 << 16);
        this.bufWriteInt(0);
        if (this.formType.equals("AIFC")) {
            this.bufWriteBytes(this.aiffEncoding);
            this.bufWriteBytes(this.aiffEncoding);
        }
        this.bufWriteBytes(SoundDataID);
        this.dataSizeOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufFlush();
        this.headerSize = this.filePointer;
    }

    public Format setInputFormat(Format format, int n2) {
        String string = null;
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.audioFormat = (AudioFormat)format;
        String string2 = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        this.blockAlign = this.channels * this.sampleSizeInBits / 8;
        if (string2.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8 && this.audioFormat.getEndian() == 0) {
                return null;
            }
            if (this.audioFormat.getSigned() == 0) {
                return null;
            }
            if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                format = this.audioFormat.intersects(this.bigEndian);
            }
            this.formType = "AIFF";
            this.aiffEncoding = "NONE";
        } else {
            this.formType = "AIFC";
            if (string2.equalsIgnoreCase("ULAW")) {
                this.aiffEncoding = "ulaw";
            } else if (string2.equalsIgnoreCase("alaw")) {
                this.aiffEncoding = "alaw";
            } else if (string2.equalsIgnoreCase("ima4")) {
                this.aiffEncoding = "ima4";
                this.blockAlign = 34 * this.channels;
            } else if (string2.equalsIgnoreCase("MAC3")) {
                this.aiffEncoding = string2;
                this.blockAlign = 2;
            } else if (string2.equalsIgnoreCase("MAC6")) {
                this.aiffEncoding = string2;
                this.blockAlign = 1;
            } else {
                string = "Cannot handle encoding " + string2;
            }
        }
        if (string == null) {
            this.inputs[0] = format;
            return format;
        }
        return null;
    }

    protected void writeFooter() {
        byte[] byArray = new byte[]{0};
        this.dataSize = this.filePointer - this.headerSize;
        if ((this.filePointer & 1) != 0) {
            this.write(byArray, 0, 1);
        }
        this.bufClear();
        this.seek(4);
        this.bufWriteInt(this.fileSize);
        this.bufFlush();
        this.bufClear();
        this.seek(this.maxFramesOffset);
        this.maxFrames = this.dataSize / this.blockAlign;
        this.bufWriteInt(this.maxFrames);
        this.bufFlush();
        this.bufClear();
        this.seek(this.dataSizeOffset);
        this.bufWriteInt(this.dataSize + 8);
        this.bufFlush();
    }
}

