/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class GsmParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int samplesPerBlock;
    private int bytesPerSecond = 1650;
    private int blockSize = 33;
    private long minLocation;
    private long maxLocation;
    private PullSourceStream stream = null;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_gsm")};

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        this.readHeader();
        this.bufferSize = this.bytesPerSecond;
        this.tracks[0] = new GsmTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        this.minLocation = this.getLocation(this.stream);
        long l2 = this.stream.getContentLength();
        if (l2 != -1L) {
            double d2 = l2 / (long)this.bytesPerSecond;
            this.duration = new Time(d2);
            this.maxLocation = l2;
        } else {
            this.maxLocation = Long.MAX_VALUE;
        }
        boolean bl = true;
        boolean bl2 = false;
        this.format = new AudioFormat("gsm", 8000.0, 16, 1, bl2 ? 1 : 0, bl ? 1 : 0, this.blockSize * 8, -1.0, Format.byteArray);
    }

    public Time setPosition(Time time, int n2) {
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long l2 = time.getNanoseconds();
        if (l2 < 0L) {
            l2 = 0L;
        }
        double d2 = (double)(l2 * (long)this.bytesPerSecond) / 1.0E9;
        double d3 = d2 % (double)this.blockSize;
        long l3 = (long)(d2 - d3);
        if (d3 > 0.0) {
            switch (n2) {
                case 1: {
                    l3 += (long)this.blockSize;
                    break;
                }
                case 3: {
                    if (!(d3 > (double)this.blockSize / 2.0)) break;
                    l3 += (long)this.blockSize;
                }
            }
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(l3 += this.minLocation);
        if (this.cacheStream != null) {
            GsmParser gsmParser = this;
            synchronized (gsmParser) {
                this.cacheStream.abortRead();
            }
        }
        return time;
    }

    public Time getMediaTime() {
        long l2 = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long l3 = l2 != -1L ? l2 - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)l3 / (double)this.bytesPerSecond);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        long l2;
        if (this.duration.equals(Duration.DURATION_UNKNOWN) && this.tracks[0] != null && (l2 = ((BasicTrack)this.tracks[0]).getMediaSizeAtEOM()) > 0L) {
            double d2 = l2 / (long)this.bytesPerSecond;
            this.duration = new Time(d2);
        }
        return this.duration;
    }

    public String getName() {
        return "Parser for raw GSM";
    }

    class GsmTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame = 0.02f;
        private SettableTime frameToTime = new SettableTime();

        GsmTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3, long l2, long l3) {
            super(GsmParser.this, audioFormat, bl, GsmParser.this.duration, time, n2, n3, GsmParser.this.stream, l2, l3);
            double d2 = audioFormat.getSampleRate();
            int n4 = audioFormat.getChannels();
            int n5 = audioFormat.getSampleSizeInBits();
            long l4 = this.duration.getNanoseconds();
        }

        GsmTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3) {
            this(audioFormat, bl, time, n2, n3, 0L, Long.MAX_VALUE);
        }
    }
}

