/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.BasicPlugIn;
import com.sun.media.protocol.v4l.V4LCapture;
import com.sun.media.protocol.v4l.V4LDeviceQuery;
import com.sun.media.protocol.v4l.VCapability;
import com.sun.media.protocol.v4l.VChannel;
import com.sun.media.protocol.v4l.VPicture;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.SystemTimeBase;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class V4LSourceStream
implements PushBufferStream,
FormatControl,
Runnable {
    protected CaptureDeviceInfo cdi = null;
    protected FormatControl[] formatControls = null;
    protected ContentDescriptor cd = new ContentDescriptor("raw");
    protected Format[] supportedFormats = null;
    protected int maxDataLength;
    protected byte[] data;
    protected int deviceNo = 0;
    protected int seqNo = 0;
    protected VideoFormat currentFormat = null;
    protected VideoFormat requestedFormat = null;
    protected int requestedPort = -1;
    protected boolean started = false;
    protected boolean stopped = true;
    protected Thread thread;
    protected float frameRate = 30.0f;
    protected BufferTransferHandler transferHandler;
    protected Control[] controls = new Control[0];
    protected V4LCapture capture;
    SystemTimeBase systemTimeBase = new SystemTimeBase();

    public V4LSourceStream(MediaLocator mediaLocator) {
        VideoFormat videoFormat = this.parseLocator(mediaLocator);
        if (this.getCaptureDeviceInfo() == null) {
            throw new Error("No such capture device!");
        }
        this.requestedFormat = (VideoFormat)this.getSupportedFormats()[0];
        if (videoFormat != null) {
            this.requestedFormat = (VideoFormat)videoFormat.intersects(this.requestedFormat);
        }
        try {
            this.capture = new V4LCapture(this.deviceNo);
        }
        catch (Throwable throwable) {
            throw new Error("Couldn't initialize capture device");
        }
        if (this.requestedPort != -1) {
            this.setPort(this.requestedPort);
        }
        this.setFormat(this.requestedFormat);
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.cdi == null) {
            String string = "v4l://" + this.deviceNo;
            Vector vector = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
            if (vector != null && vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(n2);
                    if (captureDeviceInfo.getLocator().toString().equalsIgnoreCase(string)) {
                        this.cdi = captureDeviceInfo;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.cdi == null) {
                this.cdi = this.autoDetect(this.deviceNo);
            }
        }
        if (this.cdi != null) {
            this.supportedFormats = this.cdi.getFormats();
        }
        return this.cdi;
    }

    protected CaptureDeviceInfo autoDetect(int n2) {
        V4LDeviceQuery v4LDeviceQuery;
        block3: {
            v4LDeviceQuery = null;
            try {
                v4LDeviceQuery = new V4LDeviceQuery(n2);
                if (v4LDeviceQuery != null && v4LDeviceQuery.getFormats() != null && v4LDeviceQuery.getFormats().length > 0 && CaptureDeviceManager.addDevice(v4LDeviceQuery)) {
                    CaptureDeviceManager.commit();
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        return v4LDeviceQuery;
    }

    public FormatControl[] getFormatControls() {
        if (this.formatControls == null) {
            this.formatControls = new FormatControl[1];
            this.formatControls[0] = this;
        }
        return this.formatControls;
    }

    protected VideoFormat parseLocator(MediaLocator mediaLocator) {
        this.deviceNo = this.getDeviceNo(mediaLocator);
        return null;
    }

    protected int getDeviceNo(MediaLocator mediaLocator) {
        int n2;
        block4: {
            n2 = 0;
            String string = mediaLocator.getRemainder();
            if (string == null || string.length() <= 0) break block4;
            while (string.length() > 1 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            try {
                Integer n3 = Integer.valueOf(string);
                if (n3 != null) {
                    n2 = n3;
                }
            }
            catch (Throwable throwable) {}
        }
        return n2;
    }

    protected void setPort(String string) {
        string = string.toLowerCase();
        VCapability vCapability = new VCapability();
        this.capture.getCapability(vCapability);
        int n2 = 0;
        while (n2 < vCapability.channels) {
            VChannel vChannel = new VChannel(n2);
            this.capture.getChannel(vChannel);
            if (vChannel.name != null && vChannel.name.toLowerCase().indexOf(string) >= 0) {
                this.capture.setChannel(vChannel);
                return;
            }
            ++n2;
        }
    }

    protected void setPort(int n2) {
    }

    public Format[] getSupportedFormats() {
        return this.supportedFormats;
    }

    public Format setFormat(Format format) {
        if (BasicPlugIn.matches(format, this.getSupportedFormats()) == null) {
            return null;
        }
        this.requestedFormat = (VideoFormat)format;
        if (!this.started) {
            return this.handleFormatChange();
        }
        return this.requestedFormat;
    }

    protected Format handleFormatChange() {
        VideoFormat videoFormat = this.requestedFormat;
        this.requestedFormat = null;
        int n2 = this.capture.formatToPalette(videoFormat);
        float f2 = videoFormat.getFrameRate();
        if (f2 < 0.0f) {
            f2 = 30.0f;
        }
        VPicture vPicture = new VPicture();
        this.capture.getPicture(vPicture);
        vPicture.palette = n2;
        vPicture.depth = this.capture.paletteToDepth(n2);
        this.capture.setPicture(vPicture);
        if (this.capture.setFormat(vPicture.depth, n2, videoFormat.getSize().width, videoFormat.getSize().height, f2) < 0) {
            return null;
        }
        this.currentFormat = videoFormat;
        return this.currentFormat;
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isEnabled() {
        return true;
    }

    public Component getControlComponent() {
        return null;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.cd;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return false;
    }

    public Format getFormat() {
        return this.currentFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        int n2 = 0;
        if (!this.started) {
            throw new IOException("Not started");
        }
        this.maxDataLength = this.currentFormat.getMaxDataLength();
        Object object = buffer.getData();
        if (!(object instanceof byte[]) || ((byte[])object).length < this.maxDataLength) {
            object = new byte[this.maxDataLength];
            buffer.setData(object);
        }
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            int n3 = 0;
            while ((n2 = this.capture.readNextFrame((byte[])object, 0, this.maxDataLength)) < 0 && n3 < 20) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
            }
            buffer.setFormat(this.currentFormat);
            buffer.setSequenceNumber(this.seqNo);
            buffer.setLength(this.maxDataLength);
            buffer.setFlags(32912);
            buffer.setHeader(null);
            buffer.setTimeStamp(this.systemTimeBase.getNanoseconds());
            ++this.seqNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            this.transferHandler = bufferTransferHandler;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(boolean bl) {
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            if (this.started == bl) {
                return;
            }
            this.started = bl;
            if (bl) {
                if (this.requestedFormat != null) {
                    this.handleFormatChange();
                }
                this.thread = new Thread(this);
                this.capture.start();
                this.thread.start();
            } else {
                this.stopped = true;
                this.capture.stop();
            }
            this.notifyAll();
        }
    }

    synchronized void close() {
        if (this.capture != null) {
            if (this.started) {
                this.start(false);
            }
            this.capture.close();
            this.capture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.stopped = false;
        while (this.started) {
            V4LSourceStream v4LSourceStream = this;
            synchronized (v4LSourceStream) {
                while (this.transferHandler == null && this.started) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.started || this.transferHandler == null) continue;
            }
            this.transferHandler.transferData(this);
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stopped = true;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (clazz.isInstance(objectArray[n2])) {
                    return objectArray[n2];
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

