/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.renderer.video.Blitter;
import com.sun.media.util.Arch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class AWTRenderer
extends BasicVideoRenderer
implements Blitter {
    private static final String MyName = "AWT Renderer";
    private transient Vector cacheInputData = null;
    private transient Vector cacheInputImage = null;
    private transient Vector cacheOutputImage = null;
    private transient Image lastImage = null;
    private RGBFormat supportedRGB = null;
    private RGBFormat supportedOther = null;
    private transient int lastWidth = 1;
    private transient int lastHeight = 1;
    private Blitter blitter = null;
    public static String vendor = null;
    public static boolean runningOnMac = false;

    public AWTRenderer() {
        this(MyName);
    }

    public AWTRenderer(String string) {
        super(string);
        int n2;
        int n3;
        int n4;
        if ((Arch.getArch() & 8) != 0 && !runningOnMac) {
            n4 = 255;
            n3 = 65280;
            n2 = 0xFF0000;
        } else {
            n2 = 255;
            n3 = 65280;
            n4 = 0xFF0000;
        }
        this.supportedRGB = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, n4, n3, n2, 1, -1, 0, -1);
        this.supportedOther = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, n2, n3, n4, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[2];
        this.supportedFormats[0] = this.supportedRGB;
        this.supportedFormats[1] = this.supportedOther;
        if (runningOnMac) {
            this.supportedFormats[1] = this.supportedRGB;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.media.renderer.video.Java2DRenderer");
            this.blitter = (Blitter)clazz.newInstance();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.blitter = this;
        }
    }

    public boolean isLightWeight() {
        return false;
    }

    public void open() throws ResourceUnavailableException {
        this.cacheInputData = new Vector();
        this.cacheInputImage = new Vector();
        this.cacheOutputImage = new Vector();
    }

    public synchronized void reset() {
        this.cacheInputData = new Vector();
        this.cacheInputImage = new Vector();
        this.cacheOutputImage = new Vector();
    }

    public Format setInputFormat(Format format) {
        if (super.setInputFormat(format) != null) {
            this.reset();
            return format;
        }
        return null;
    }

    protected synchronized int doProcess(Buffer buffer) {
        Object object;
        Object object2;
        if (this.component == null) {
            return 0;
        }
        if (!buffer.getFormat().equals(this.inputFormat)) {
            object2 = buffer.getFormat();
            if (BasicPlugIn.matches((Format)object2, this.supportedFormats) == null) {
                return 1;
            }
            this.inputFormat = (RGBFormat)object2;
        }
        if (!((object2 = buffer.getData()) instanceof int[])) {
            return 1;
        }
        int n2 = this.cacheInputData.size();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            object = this.cacheInputData.elementAt(n3);
            if (object == object2) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            n3 = this.blitter.newData(buffer, this.cacheInputImage, this.cacheOutputImage, this.cacheInputData);
        }
        if (n3 < 0) {
            return 1;
        }
        object = (RGBFormat)buffer.getFormat();
        Dimension dimension = ((VideoFormat)object).getSize();
        this.inWidth = dimension.width;
        this.inHeight = dimension.height;
        if (this.outWidth == -1) {
            this.outWidth = dimension.width;
        }
        if (this.outHeight == -1) {
            this.outHeight = dimension.height;
        }
        this.lastImage = this.blitter.process(buffer, this.cacheInputImage.elementAt(n3), this.cacheOutputImage.elementAt(n3), dimension);
        this.lastWidth = dimension.width;
        this.lastHeight = dimension.height;
        if (!this.isLightWeight()) {
            Graphics graphics = this.component.getGraphics();
            if (graphics != null) {
                this.blitter.draw(graphics, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, dimension.width, dimension.height);
            }
        } else {
            this.component.repaint();
        }
        return 0;
    }

    protected void repaint() {
        if (!this.isStarted() && this.lastImage != null) {
            Graphics graphics = this.component.getGraphics();
            this.blitter.draw(graphics, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, this.lastWidth, this.lastHeight);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.isLightWeight()) {
                this.component = new LightComponent();
                this.component.setBackground(this.getPreferredBackground());
                if (this.compListener == null) {
                    this.compListener = new BasicVideoRenderer.CompListener();
                }
                this.component.addComponentListener(this.compListener);
            } else {
                this.component = super.getComponent();
            }
        }
        return this.component;
    }

    public synchronized void resized(Component component) {
        super.resized(component);
        if (this.blitter != this) {
            this.blitter.resized(component);
        }
    }

    public Image process(Buffer buffer, Object object, Object object2, Dimension dimension) {
        MemoryImageSource memoryImageSource = (MemoryImageSource)object;
        Image image = (Image)object2;
        memoryImageSource.newPixels(0, 0, dimension.width, dimension.height);
        return image;
    }

    public void draw(Graphics graphics, Component component, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (graphics != null) {
            graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, component);
        }
    }

    public void paint(Graphics graphics) {
        if (graphics != null && this.lastImage != null) {
            this.blitter.draw(graphics, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, this.lastWidth, this.lastHeight);
        }
    }

    public int newData(Buffer buffer, Vector vector, Vector vector2, Vector vector3) {
        Object object = buffer.getData();
        if (!(object instanceof int[])) {
            return -1;
        }
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        DirectColorModel directColorModel = new DirectColorModel(rGBFormat.getBitsPerPixel(), rGBFormat.getRedMask(), rGBFormat.getGreenMask(), rGBFormat.getBlueMask());
        MemoryImageSource memoryImageSource = new MemoryImageSource(rGBFormat.getLineStride(), rGBFormat.getSize().height, (ColorModel)directColorModel, (int[])object, 0, rGBFormat.getLineStride());
        memoryImageSource.setAnimated(true);
        memoryImageSource.setFullBufferUpdates(true);
        Image image = null;
        if (this.component != null) {
            image = this.component.createImage(memoryImageSource);
            this.component.prepareImage(image, this.component);
        }
        vector2.addElement(image);
        vector3.addElement(object);
        vector.addElement(memoryImageSource);
        return vector.size() - 1;
    }

    static {
        try {
            vendor = System.getProperty("java.vendor");
            if (vendor != null && (vendor = vendor.toUpperCase()).startsWith("APPLE")) {
                runningOnMac = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class LightComponent
    extends Component {
        public synchronized void paint(Graphics graphics) {
            AWTRenderer.this.paint(graphics);
        }

        public synchronized void update(Graphics graphics) {
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        public Dimension getPreferredSize() {
            return AWTRenderer.this.myPreferredSize();
        }

        public synchronized void addNotify() {
            super.addNotify();
            AWTRenderer.this.setAvailable(true);
        }

        public synchronized void removeNotify() {
            AWTRenderer.this.setAvailable(false);
            super.removeNotify();
        }
    }
}

