/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SlowPlugIn;
import com.sun.media.renderer.video.BasicVideoRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class JPEGRenderer
extends BasicVideoRenderer
implements SlowPlugIn {
    private static final String MyName = "JPEG Renderer";
    private VideoFormat supportedJPEG = null;
    private VideoFormat supportedMJPG = null;
    private boolean forceToFail = false;

    public void forceToUse() {
        this.forceToFail = false;
    }

    public JPEGRenderer() {
        super(MyName);
        if (BasicPlugIn.plugInExists("com.sun.media.codec.video.jpeg.NativeDecoder", 2)) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmjpeg");
                this.forceToFail = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.supportedJPEG = new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f);
        this.supportedMJPG = new VideoFormat("mjpg", null, -1, Format.byteArray, -1.0f);
        this.supportedFormats = new VideoFormat[1];
        this.supportedFormats[0] = this.supportedJPEG;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        if (this.forceToFail) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            this.reset();
            return format;
        }
        return null;
    }

    public synchronized int doProcess(Buffer buffer) {
        Cloneable cloneable;
        if (this.component == null) {
            return 0;
        }
        if (!buffer.getFormat().equals(this.inputFormat)) {
            cloneable = buffer.getFormat();
            if (!cloneable.matches(this.supportedJPEG)) {
                return 1;
            }
            this.inputFormat = (VideoFormat)cloneable;
        }
        cloneable = this.inputFormat.getSize();
        Object object = buffer.getData();
        if (!(object instanceof byte[])) {
            return 1;
        }
        Image image = Toolkit.getDefaultToolkit().createImage((byte[])object);
        MediaTracker mediaTracker = new MediaTracker(this.component);
        Dimension dimension = this.component.getSize();
        this.outWidth = dimension.width;
        this.outHeight = dimension.height;
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Graphics graphics = this.component.getGraphics();
        if (graphics != null) {
            graphics.drawImage(image, 0, 0, this.outWidth, this.outHeight, 0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height, this.component);
        }
        return 0;
    }

    protected void repaint() {
    }
}

