/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class H261Format
extends VideoFormat {
    protected int stillImageTransmission = -1;
    private static String ENCODING = "h261";

    public H261Format() {
        super(ENCODING);
    }

    public H261Format(Dimension dimension, int n2, Class clazz, float f2, int n3) {
        super(ENCODING, dimension, n2, clazz, f2);
        this.stillImageTransmission = n3;
    }

    public int getStillImageTransmission() {
        return this.stillImageTransmission;
    }

    public Object clone() {
        H261Format h261Format = new H261Format();
        h261Format.copy(this);
        return h261Format;
    }

    protected void copy(Format format) {
        super.copy(format);
        this.stillImageTransmission = ((H261Format)format).stillImageTransmission;
    }

    public String toString() {
        return "H.261 video format";
    }

    public boolean equals(Object object) {
        if (object instanceof H261Format) {
            return super.equals(object) && this.stillImageTransmission == ((H261Format)object).stillImageTransmission;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof H261Format)) {
            return true;
        }
        H261Format h261Format = (H261Format)format;
        return this.stillImageTransmission == -1 || h261Format.stillImageTransmission == -1 || this.stillImageTransmission == h261Format.stillImageTransmission;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof H261Format)) {
            return format2;
        }
        H261Format h261Format = (H261Format)format;
        H261Format h261Format2 = (H261Format)format2;
        h261Format2.stillImageTransmission = this.stillImageTransmission != -1 ? this.stillImageTransmission : h261Format.stillImageTransmission;
        return h261Format2;
    }
}

