/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.utils.TrackableThread;

public class FadeTracker {
    public static final int END_VALUE = 10;
    private static FadeTracker instance;
    private Map trackedComponents;
    private FadeTrackerThread trackerThread = this.getThread();

    private FadeTracker() {
        this.trackedComponents = new HashMap();
    }

    public static synchronized FadeTracker getInstance() {
        if (instance == null) {
            instance = new FadeTracker();
        }
        return instance;
    }

    private synchronized void updateComponents() {
        HashSet<Container> parents = new HashSet<Container>();
        Iterator itComp = this.trackedComponents.entrySet().iterator();
        while (itComp.hasNext()) {
            Map.Entry entry = itComp.next();
            Map mapComp = (Map)entry.getValue();
            Iterator itKind = mapComp.entrySet().iterator();
            while (itKind.hasNext()) {
                Map.Entry entryKind = itKind.next();
                FadeState state = (FadeState)entryKind.getValue();
                if (state.isFadingIn) {
                    state.fadePosition += state.fadeStep;
                    if (state.fadePosition > 10) {
                        state.fadePosition = 10;
                        itKind.remove();
                    }
                } else {
                    state.fadePosition -= state.fadeStep;
                    if (state.fadePosition < 0) {
                        itKind.remove();
                    }
                }
                if (state.callback != null) {
                    state.callback.fadePerformed(state.fadeKind);
                    continue;
                }
                if (state.toRepaintParent) {
                    parents.add(((ComponentId)entry.getKey()).component.getParent());
                    continue;
                }
                ((ComponentId)entry.getKey()).component.repaint();
            }
            if (mapComp.size() != 0) continue;
            itComp.remove();
        }
        for (Component component : parents) {
            component.repaint();
        }
    }

    private synchronized FadeState getState(FadeKind fadeKind, Component comp, int componentId) {
        ComponentId cid = new ComponentId(comp, componentId);
        HashMap map = (HashMap)this.trackedComponents.get(cid);
        if (map == null) {
            map = new HashMap();
            this.trackedComponents.put(cid, map);
        }
        return (FadeState)map.get(fadeKind);
    }

    private synchronized void addState(Component comp, int componentId, FadeKind fadeKind, FadeState fadeState) {
        ComponentId cid = new ComponentId(comp, componentId);
        HashMap<FadeKind, FadeState> map = (HashMap<FadeKind, FadeState>)this.trackedComponents.get(cid);
        if (map == null) {
            map = new HashMap<FadeKind, FadeState>();
            this.trackedComponents.put(cid, map);
        }
        map.put(fadeKind, fadeState);
    }

    public synchronized void trackFadeIn(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        this.trackFadeIn(fadeKind, comp, 0, toRepaintParent, callback);
    }

    public synchronized void trackFadeIn(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        if (!comp.isDisplayable()) {
            return;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 0, true, toRepaintParent);
            fadeState.fadeStep = LafWidgetUtilities.getAnimationKind(comp).getStep();
            this.addState(comp, componentId, fadeKind, fadeState);
        } else {
            fadeState.isFadingIn = true;
        }
        fadeState.callback = callback;
    }

    public synchronized void trackFadeOut(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        this.trackFadeOut(fadeKind, comp, 0, toRepaintParent, callback);
    }

    public synchronized void trackFadeOut(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        if (!comp.isDisplayable()) {
            return;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 10, false, toRepaintParent);
            fadeState.fadeStep = LafWidgetUtilities.getAnimationKind(comp).getStep();
            this.addState(comp, componentId, fadeKind, fadeState);
        } else {
            fadeState.isFadingIn = false;
        }
        fadeState.callback = callback;
    }

    public synchronized void trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent) {
        this.trackFade(comp, fadeKind, isFadeIn, toRepaintParent, null);
    }

    public synchronized void trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent, FadeTrackerCallback callback) {
        if (isFadeIn) {
            this.trackFadeIn(fadeKind, comp, toRepaintParent, callback);
        } else {
            this.trackFadeOut(fadeKind, comp, toRepaintParent, callback);
        }
    }

    public boolean isTracked(Component comp, FadeKind fadeKind) {
        return this.isTracked(comp, 0, fadeKind);
    }

    public boolean isTracked(Component comp, int componentId, FadeKind fadeKind) {
        ComponentId cid = new ComponentId(comp, componentId);
        Map map = (Map)this.trackedComponents.get(cid);
        if (map == null) {
            return false;
        }
        if (fadeKind == null) {
            return map.size() > 0;
        }
        return map.containsKey(fadeKind);
    }

    public synchronized int getFade(Component comp, FadeKind fadeKind) {
        return this.getFade(comp, 0, fadeKind);
    }

    public synchronized int getFade(Component comp, int componentId, FadeKind fadeKind) {
        Iterator it;
        ComponentId cid = new ComponentId(comp, componentId);
        Map map = (Map)this.trackedComponents.get(cid);
        if (map == null || map.size() == 0) {
            return 0;
        }
        if (fadeKind == null && (it = map.values().iterator()).hasNext()) {
            FadeState fs = (FadeState)it.next();
            return fs.fadePosition;
        }
        FadeState state = (FadeState)map.get(fadeKind);
        if (state == null) {
            return 0;
        }
        return state.fadePosition;
    }

    public synchronized void stopAllTimers() {
        this.trackedComponents.clear();
    }

    private synchronized FadeTrackerThread getThread() {
        if (this.trackerThread == null) {
            this.trackerThread = new FadeTrackerThread();
            this.trackerThread.start();
        }
        return this.trackerThread;
    }

    private class FadeTrackerThread
    extends TrackableThread {
        public static final int DELAY = 40;
        private boolean stopRequested;

        public FadeTrackerThread() {
            this.setName("Laf-Widget fade tracker");
            this.stopRequested = false;
        }

        public void run() {
            while (!this.stopRequested) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FadeTracker.this.updateComponents();
                    }
                });
            }
        }

        protected void requestStop() {
            this.stopRequested = true;
            FadeTracker.this.trackerThread = null;
        }
    }

    private static class FadeState {
        public int fadePosition;
        public boolean isFadingIn;
        public boolean toRepaintParent;
        public FadeTrackerCallback callback;
        public int fadeStep;
        public FadeKind fadeKind;

        public FadeState(FadeKind fadeKind, int fadePosition, boolean isFadingIn, boolean toRepaintParent) {
            this.fadeKind = fadeKind;
            this.fadePosition = fadePosition;
            this.isFadingIn = isFadingIn;
            this.toRepaintParent = toRepaintParent;
        }
    }

    public static interface FadeTrackerCallback {
        public void fadePerformed(FadeKind var1);
    }

    protected static class ComponentId {
        public Component component;
        public int id;

        public ComponentId(Component component, int id) {
            this.component = component;
            this.id = id;
        }

        public int hashCode() {
            int result = this.component.hashCode();
            return result &= this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComponentId) {
                ComponentId cid = (ComponentId)obj;
                return this.component == cid.component && this.id == cid.id;
            }
            return false;
        }
    }

    public static class FadeKind {
        public static final FadeKind ARM = new FadeKind();
        public static final FadeKind PRESS = new FadeKind();
        public static final FadeKind FOCUS = new FadeKind();
        public static final FadeKind ENABLE = new FadeKind();
        public static final FadeKind ROLLOVER = new FadeKind();
        public static final FadeKind SELECTION = new FadeKind();
        public static final FadeKind MARKED_MODIFIED = new FadeKind();

        private FadeKind() {
        }
    }
}

