/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceRadioButtonUI
extends MetalRadioButtonUI {
    private static final int DIMENSION = 11;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    protected JToggleButton button;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    protected FadeStateListener fadeStateListener;

    public static synchronized void reset() {
        icons.clear();
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.fadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.fadeStateListener.registerListeners();
    }

    protected void uninstallListeners(AbstractButton b) {
        this.fadeStateListener.unregisterListeners();
        this.fadeStateListener = null;
        super.uninstallListeners(b);
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState state) {
        ColorScheme colorScheme;
        int visibility;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        int n = visibility = state.isSelected() ? 10 : 0;
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
            visibility = fadeTracker.getFade(button, FadeTracker.FadeKind.SELECTION);
        }
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(button);
            ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
            int cyclePos = 0;
            if (!state.isSelected() && state.isEnabled()) {
                if (state == ComponentState.DEFAULT) {
                    colorScheme2 = metallicScheme;
                    cyclePos = 10 - fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                } else {
                    colorScheme2 = colorScheme;
                    colorScheme = metallicScheme;
                    cyclePos = fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                }
                String key = state.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + visibility;
                Icon result = icons.get(key);
                if (result != null) {
                    return result;
                }
                result = new ImageIcon(SubstanceImageCreator.getRadioButton(11, state, 0, colorScheme, colorScheme2, cyclePos, (float)visibility / 10.0f));
                icons.put(key, result);
                return result;
            }
        }
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        colorScheme = SubstanceCoreUtilities.getControlColorScheme(button, kind);
        int cyclePos = state.getCycleCount();
        String key = state.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + cyclePos + ":" + visibility;
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(11, state, 0, colorScheme, colorScheme, cyclePos, (float)visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceRadioButtonUI((JToggleButton)b);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return SubstanceRadioButtonUI.getIcon(this.button, ComponentState.getState(model, this.button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            this.bgDelegate.update(g, c);
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            this.bgDelegate.update(g, c);
            super.paint(g, c);
            c.setOpaque(isOpaque);
        }
        AbstractButton b = (AbstractButton)c;
        if (!b.isFocusPainted()) {
            return;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        size = b.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(text == null || textRect.width <= 0 || textRect.height <= 0 || b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeTracker.FadeKind.FOCUS))) {
            this.paintFocus(g, textRect, size);
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(this.button);
        if (focusKind == SubstanceConstants.FocusKind.NONE && !fadeTracker.isTracked(this.button, FadeTracker.FadeKind.FOCUS)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        if (fadeTracker.isTracked(this.button, FadeTracker.FadeKind.FOCUS)) {
            alpha = (float)fadeTracker.getFade(this.button, FadeTracker.FadeKind.FOCUS) / 10.0f;
        }
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        ColorScheme currScheme = SubstanceCoreUtilities.getActiveScheme(this.button);
        Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(this.button)) ? SubstanceColorUtilities.getInterpolatedColor(currScheme.getUltraLightColor(), currScheme.getForegroundColor(), 0.4) : SubstanceColorUtilities.getInterpolatedColor(currScheme.getMidColor(), currScheme.getDarkColor(), 0.5);
        graphics.setColor(color);
        if (focusKind == SubstanceConstants.FocusKind.TEXT || focusKind == SubstanceConstants.FocusKind.ALL || focusKind == SubstanceConstants.FocusKind.ALL_INNER) {
            if (focusKind != SubstanceConstants.FocusKind.TEXT) {
                graphics.translate(1, 1);
            } else {
                graphics.translate(t.x - 1, t.y - 1);
            }
            GeneralPath contour = focusKind != SubstanceConstants.FocusKind.TEXT ? BaseButtonShaper.getBaseOutline(d.width - 2, d.height - 2, 3.0f, null) : BaseButtonShaper.getBaseOutline(t.width + 2, t.height + 2, 2.0f, null);
            graphics.setStroke(new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            graphics.draw(contour);
        }
        if (focusKind == SubstanceConstants.FocusKind.STRONG_UNDERLINE) {
            graphics.drawLine(t.x, t.y + t.height, t.x + t.width, t.y + t.height);
        }
        if (focusKind == SubstanceConstants.FocusKind.UNDERLINE) {
            graphics.setStroke(new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            graphics.drawLine(t.x, t.y + t.height, t.x + t.width, t.y + t.height);
        }
        graphics.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

